% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfdb-io.R
\name{wfdb_io}
\alias{wfdb_io}
\alias{write_wfdb}
\alias{read_wfdb}
\alias{read_signal}
\alias{read_header}
\title{I/O of WFDB-compatible signal & header files from EP recording systems}
\usage{
write_wfdb(
  data,
  record,
  record_dir,
  wfdb_path = getOption("wfdb_path"),
  header = list(frequency = 250, gain = 200L, label = character()),
  info_strings = list(),
  ...
)

read_wfdb(
  record,
  record_dir = ".",
  annotator = NA_character_,
  wfdb_path = getOption("wfdb_path"),
  begin = 0,
  end = NA_integer_,
  interval = NA_integer_,
  units = "digital",
  channels = character(),
  ...
)

read_signal(
  record,
  record_dir = ".",
  wfdb_path = getOption("wfdb_path"),
  begin = 0L,
  end = NA_integer_,
  interval = NA_integer_,
  units = "digital",
  channels = character(),
  ...
)

read_header(record, record_dir = ".", wfdb_path = getOption("wfdb_path"), ...)
}
\arguments{
\item{data}{Can either be an \code{egm} object, or a \code{data.frame} (or similar)
object. The function will appropriately set defaults based on the type.
\itemize{
\item \code{egm} = Will extract signal and header data directly from object, and thus is simplest to convert to a WFDB format
\item \code{signal_table} = This is a customized \code{data.table} class that has an invariant column containing sample information.
\item \code{data.frame} or \code{data.table} = Must have a column that represents a time point or index, and columns that represent signal values (preferably integers)
}}

\item{record}{String that will be used to name the WFDB record. Cannot
include extensions, and is not a filepath. alphanumeric characters are
acceptable, as well as hyphens (-) and underscores (_)}

\item{record_dir}{File path of directory that should be used read and write
files. Defaults to current directory.}

\item{wfdb_path}{Path that leads to installed \code{wfdb} software package on
device. Needs to be directly set using \code{set_wfdb_path()}. Obtained from the
system options on loading of the package, \code{getOption('wfdb_path')}}

\item{header}{A header file is an optional named list of parameters that
will be used to organize and describe the signal input from the \strong{data}
argument. If the \strong{type} is given, specific additional elements will be
searched for, such as the low or high pass filters, colors, or other signal
attributes. At minimum, the following elements are required (as cannot be
calculated):
\itemize{
\item frequency = sample frequency in Hertz as \code{integer}
\item label = vector of names for each channel as \code{character}
\item start_time = date/time object
}}

\item{info_strings}{A \code{list} of strings that will be written as an appendix
to the header file, usually containing information about the channels,
(e.g. list of colors, extra labels, etc).}

\item{...}{Additional arguments to be passed to the function}

\item{annotator}{String that is the name of a WFDB-compatible annotation
type, serving as the extension for the file that is written containing that
annotation. Please see \code{\link[=read_annotation]{read_annotation()}} and \code{\link[=write_annotation]{write_annotation()}} for
further details.}

\item{begin, end, interval}{Timepoint as an \code{integer} (representing seconds),
which is converted to an index position based on sampling frequency. The
default is to start at the beginning of the record. If \code{end} or \code{interval}
are given, the earlier of the two will be returned. The \code{end} argument
gives a time index to read until. The \code{interval} argument is the length of
time past the start point.}

\item{units}{A \code{character} string representing either \emph{digital} (DEFAULT) or \emph{physical}
units that should be used, if available.
\itemize{
\item digital = Index in sample number, signal in integers (A/D units)
\item physical = Index in elapsed time, signal in decimal voltage (e.g. mV).
This will \strong{include 1 additional row over the header/column names} that
describes units
}}

\item{channels}{Either the signal/channel in a \code{character} vector as a name or number.
Allows for duplication of signal or to re-order signal if needed. If
nothing is given, will default to all channels available.}
}
\value{
Depends on if it is a reading or writing function. For writing, will
output an WFDB-based object reflecting the function. For reading, will
output an extension of a \code{data.table} object reflecting the underlying
function (e.g. \code{signal_table()} will return an object of class).
}
\description{
This function allows for WFDB files to be read from any WFDB-compatible
system, and also allows writing out WFDB-compatible files from specific EP
recording systems, as indicated in the details section. Writing WFDB leads to
creation of both a \strong{dat} (signal) and \strong{hea} (header) file. These are both
required for reading in files as well.
}
\section{Functions}{
\itemize{
\item \code{write_wfdb()}: Writes out signal and header data into a WFDB-compatible
format from R.

\item \code{read_wfdb()}: Reads a multicomponent WFDB-formatted set of files
directly into an \code{egm} object. This serves to pull together
\code{\link[=read_signal]{read_signal()}}, \code{\link[=read_header]{read_header()}}, and \code{\link[=read_annotation]{read_annotation()}} for simplicity.

\item \code{read_signal()}: Specifically reads the signal data from the WFDB binary
format, returning a \code{signal_table} object for evaluation in the R
environment

\item \code{read_header()}: Specifically reads the header data from the WFDB header
text format, returning a \code{header_table} object for evaluation in the R
environment

}}
\section{Recording systems}{
Type of signal data, as specified by the recording system, that are currently
supported.
\itemize{
\item \emph{bard} = Bard (LabSystem Pro), e.g. \code{\link[=read_bard]{read_bard()}}
\item \emph{muse} = MUSE (GE), e.g. \code{\link[=read_muse]{read_muse()}}
\item \emph{prucka} = Prucka (CardioLab), e.g. \code{\link[=read_prucka]{read_prucka()}}
}
}

