% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecg.R
\name{ecg}
\alias{ecg}
\alias{is_ecg}
\title{Electrocardiogram data class for 12-lead ECG studies}
\usage{
ecg(
  signal = signal_table(),
  header = header_table(),
  annotation = annotation_table(),
  ...
)

is_ecg(x)
}
\arguments{
\item{signal}{A \code{signal_table} object generated by the \code{\link[=signal_table]{signal_table()}}
function containing standard ECG leads}

\item{header}{A \code{header_table} object generated by the \code{\link[=header_table]{header_table()}}
function}

\item{annotation}{A \code{annotation_table} object generated by the
\code{\link[=annotation_table]{annotation_table()}} function}

\item{...}{Additional arguments to be passed to the function}

\item{x}{An \code{ecg} object to be used with support functions}
}
\value{
An object of class \code{ecg} (which inherits from \code{egm}) containing
signal, header, and annotation components.
}
\description{
This class serves as a specialized extension of the \code{egm} class
specifically for standard 12-lead electrocardiogram data. It inherits all
functionality from \code{egm} while providing additional validation and methods
specific to 12-lead ECG analysis.
}
\details{
The \code{ecg} object contains the same three components as \code{egm}:
\itemize{
\item signal data in multiple channels (specifically 12 standard ECG leads)
\item header information
\item annotation labels at specified time points
}

The primary difference is that this class enforces validation to ensure
the data represents a standard 12-lead ECG with appropriate lead names.
}
