% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemStability.R
\name{itemStability}
\alias{itemStability}
\title{Item Stability Statistics from \code{\link[EGAnet]{bootEGA}}}
\usage{
itemStability(bootega.obj, IS.plot = TRUE, structure = NULL, ...)
}
\arguments{
\item{bootega.obj}{A \code{\link[EGAnet]{bootEGA}} object}

\item{IS.plot}{Boolean (length = 1).
Should the plot be produced for \code{item.replication}?
Defaults to \code{TRUE}}

\item{structure}{Numeric (length = number of variables).
A theoretical or pre-defined structure.
Defaults to \code{NULL} or the empirical \code{\link[EGAnet]{EGA}}
result in the \code{bootega.obj}}

\item{...}{Deprecated arguments from previous versions of \code{\link[EGAnet]{itemStability}}}
}
\value{
Returns a list containing:

\item{membership}{A list containing:

\itemize{

\item \code{empirical} --- A vector of the empirical memberships from the 
empirical \code{\link[EGAnet]{EGA}} result

\item \code{bootstrap} --- A matrix of the homogenized memberships from the replicate samples in 
the \code{\link[EGAnet]{bootEGA}} results

\item \code{structure} --- A vector of the structure used in the analysis. If \code{structure = NULL}, then this output
will be the same as \code{empirical}
   
}

}

\item{item.stability}{A list containing:

\itemize{

\item \code{empirical.dimensions} --- A vector of the proportion of times each item replicated
within the structure defined by \code{structure}

\item \code{all.dimensions} --- A matrix of the proportion of times each item replicated
in each of the \code{structure} defined dimensions

}

}

\item{plot}{Plot output if \code{IS.plot = TRUE}}
}
\description{
Based on the \code{\link[EGAnet]{bootEGA}} results, this function
computes and plots the number of times an variable is estimated
in the same dimension as originally estimated by an empirical
\code{\link[EGAnet]{EGA}} structure or a theoretical/input structure.
The output also contains each variable's replication frequency (i.e., proportion of
bootstraps that a variable appeared in each dimension
}
\examples{
# Load data
wmt <- wmt2[,7:24]

\dontrun{
# Standard EGA example
boot.wmt <- bootEGA(
  data = wmt, iter = 500,
  type = "parametric", ncores = 2
)}

# Standard item stability 
wmt.is <- itemStability(boot.wmt)

\dontrun{
# EGA fit example
boot.wmt.fit <- bootEGA(
  data = wmt, iter = 500,
  EGA.type = "EGA.fit",
  type = "parametric", ncores = 2
)

# EGA fit item stability 
wmt.is.fit <- itemStability(boot.wmt.fit)

# Hierarchical EGA example
boot.wmt.hier <- bootEGA(
  data = wmt, iter = 500,
  EGA.type = "hierEGA",
  type = "parametric", ncores = 2
)

# Hierarchical EGA item stability 
wmt.is.hier <- itemStability(boot.wmt.hier)

# Random-intercept EGA example
boot.wmt.ri <- bootEGA(
  data = wmt, iter = 500,
  EGA.type = "riEGA",
  type = "parametric", ncores = 2
)

# Random-intercept EGA item stability 
wmt.is.ri <- itemStability(boot.wmt.ri)}

}
\references{
\strong{Original implementation of bootEGA} \cr
Christensen, A. P., & Golino, H. (2021).
Estimating the stability of the number of factors via Bootstrap Exploratory Graph Analysis: A tutorial.
\emph{Psych}, \emph{3}(3), 479-500.

\strong{Conceptual introduction} \cr
Christensen, A. P., Golino, H., & Silvia, P. J. (2020).
A psychometric network perspective on the validity and validation of personality trait questionnaires.
\emph{European Journal of Personality}, \emph{34}(6), 1095-1108.
}
\seealso{
\code{\link[EGAnet]{plot.EGAnet}} for plot usage in \code{\link{EGAnet}}
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
