% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.KGC}
\alias{plot.KGC}
\title{Plot Kaiser-Guttman Criterion (KGC) Plot}
\usage{
\method{plot}{KGC}(x, ...)
}
\arguments{
\item{x}{An object of class \code{KGC}, representing the results to be plotted.}

\item{...}{Additional arguments to be passed to the plotting function.}
}
\value{
None. This function is used for side effects (plotting).
}
\description{
This function generates a Kaiser-Guttman Criterion (KGC) plot to visualize the eigenvalues
of the actual data. The Kaiser-Guttman Criterion, also known as the Kaiser criterion,
suggests retaining factors with eigenvalues greater than 1. The plot shows the eigenvalues
and includes a reference line at 1 to indicate the threshold for factor retention.
}
\examples{
library(EFAfactors)
set.seed(123)

## Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## Load data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1

\donttest{
  KGC.obj <- KGC(response)

  ## Plot the Kaiser-Guttman Criterion
  plot(KGC.obj)
}

}
\seealso{
\link[EFAfactors]{KGC}
}
