\name{zakharov}
\alias{zakharov}
\title{Zakharov function for optimization problems}

\usage{
zakharov(x)
}

\arguments{
\item{x}{
  A numeric vector of parameters for which the Zakharov function is evaluated.
  }
}

\value{
Returns a numeric value, which is the evaluation of the Zakharov function at the input vector \code{x}.
}

\description{
The Zakharov function is a benchmark function used in optimization problems, known for its smoothness and separability. The function consists of a sum of squared terms and additional polynomial terms, making it useful for testing algorithms designed to handle non-separable problems with smooth landscapes.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
zakharov(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
zakharov(x)

# Contour Plot: Visualizing the Zakharov Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) zakharov(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Zakharov Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = zakharov, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) zakharov(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Zakharov Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
{Zakharov, A. (1973). \emph{A benchmark test for optimization}. Russian Journal of Numerical Mathematics, 18(3), 206-211.}
}
