% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEAaq_summary.R
\name{EEAaq_summary}
\alias{EEAaq_summary}
\title{Generate an \code{EEAaq_df} data summary.
This function must be applied to an \code{EEAaq_df} or \code{EEAaq_df_sfc} class object and produces a list of data frames,
containing relevant information about the data, such as descriptive statistics, missing values statistics,
gap length and linear correlation.}
\usage{
EEAaq_summary(data = NULL, verbose = TRUE)
}
\arguments{
\item{data}{an \code{EEAaq_df} or \code{EEAaq_df_sfc} class object, which is the output of the \code{\link{EEAaq_get_data}} function.}

\item{verbose}{logic value (T or F). If \code{TRUE} (the default) messages about the function progress are printed.
If \code{FALSE} no message is printed.}
}
\value{
The function \code{EEAaq_summary} computes and return a list of summary statistics of the dataset given in
\code{data}. In particular the elements of the list are:
\itemize{
\item{\code{Summary} global missing count, missing rate, negative count, minimum, maximum,
mean and standard deviation, organized by pollutant.}
\item{\code{Summary_byStat} list of data frames, one for each different station, containing
the descriptive statistics (missing count, missing rate, negative count, minimum, maximum,
mean and standard deviation), organized by station.}
\item{\code{gap_length} one data frame for each pollutant, containing the gap length organized by station.}
\item{\code{Corr_Matrix} if \code{data} contains more than one pollutant, the correlation matrix between
pollutans is provided, organised by station.}
}
}
\description{
Generate an \code{EEAaq_df} data summary.
This function must be applied to an \code{EEAaq_df} or \code{EEAaq_df_sfc} class object and produces a list of data frames,
containing relevant information about the data, such as descriptive statistics, missing values statistics,
gap length and linear correlation.
}
\examples{
\donttest{
`\%>\%` <- dplyr::`\%>\%`
### Download PM10 data for the province (NUTS-3) of Milano (Italy)
###   from January 1st to January 31st, 2023
IDstations <- EEAaq_get_stations(byStation = TRUE, complete = FALSE)
IDstations <- IDstations \%>\%
                dplyr::filter(NUTS3 \%in\% c("Milano")) \%>\%
                dplyr::pull(AirQualityStationEoICode) \%>\%
                unique()
data <- EEAaq_get_data(IDstations = IDstations, pollutants = "PM10",
                       from = "2023-01-01", to = "2023-01-31",
                       verbose = TRUE)

### Compute summary statistics
EEAaq_summary(data)
}

}
