% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database_access.r
\name{get_ecotox_info}
\alias{get_ecotox_info}
\title{Get information on the local ECOTOX database when available}
\usage{
get_ecotox_info(path = get_ecotox_path(), version)
}
\arguments{
\item{path}{A \code{character} string with the path to the location of the local database (default is
\code{\link[=get_ecotox_path]{get_ecotox_path()}}).}

\item{version}{A \code{character} string referring to the release version of the database you wish to locate.
It should have the same format as the date in the EPA download link, which is month, day, year, separated by
underscores ("\%m_\%d_\%Y"). When missing, the most recent available copy is selected automatically.}
}
\value{
Returns a \code{vector} of \code{character}s, containing a information on the selected local ECOTOX database.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Get information on how and when the local ECOTOX database was build.
}
\details{
Get information on how and when the local ECOTOX database was build. This information is retrieved
from the log-file that is (optionally) stored with the local database when calling \code{\link[=download_ecotox_data]{download_ecotox_data()}}
or \code{\link[=build_ecotox_sqlite]{build_ecotox_sqlite()}}.
}
\examples{
\dontrun{
## Show info on the current database (only works when one is downloaded and build):
get_ecotox_info()
}
}
\author{
Pepijn de Vries
}
