% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{bagging_dia}
\alias{bagging_dia}
\title{Train a Bagging Diagnostic Model}
\usage{
bagging_dia(
  data,
  base_model_name,
  n_estimators = 50,
  subset_fraction = 0.632,
  tune_base_model = FALSE,
  threshold_strategy = "default",
  specific_threshold_value = 0.5,
  positive_label_value = 1,
  negative_label_value = 0,
  new_positive_label = "Positive",
  new_negative_label = "Negative",
  seed = 456
)
}
\arguments{
\item{data}{A data frame where the first column is the sample ID, the second
is the outcome label, and subsequent columns are features.}

\item{base_model_name}{A character string, the name of the base diagnostic
model to use (e.g., "rf", "lasso"). This model must be registered.}

\item{n_estimators}{An integer, the number of base models to train.}

\item{subset_fraction}{A numeric value between 0 and 1, the fraction of
samples to bootstrap for each base model.}

\item{tune_base_model}{Logical, whether to enable tuning for each base model.}

\item{threshold_strategy}{A character string (e.g., "f1", "youden", "default")
or a numeric value (0-1) for determining the evaluation threshold for the ensemble.}

\item{specific_threshold_value}{A numeric value between 0 and 1. Only used
if \code{threshold_strategy} is "numeric".}

\item{positive_label_value}{A numeric or character value in the raw data
representing the positive class.}

\item{negative_label_value}{A numeric or character value in the raw data
representing the negative class.}

\item{new_positive_label}{A character string, the desired factor level name
for the positive class (e.g., "Positive").}

\item{new_negative_label}{A character string, the desired factor level name
for the negative class (e.g., "Negative").}

\item{seed}{An integer, for reproducibility.}
}
\value{
A list containing the \code{model_object}, \code{sample_score}, and \code{evaluation_metrics}.
}
\description{
Implements a Bagging (Bootstrap Aggregating) ensemble for
diagnostic models. It trains multiple base models on bootstrapped samples
of the training data and aggregates their predictions by averaging probabilities.
}
\examples{
\donttest{
# This example assumes your package includes a dataset named 'train_dia'.
# If not, create a toy data frame first.
if (exists("train_dia")) {
  initialize_modeling_system_dia()

  bagging_rf_results <- bagging_dia(
    data = train_dia,
    base_model_name = "rf",
    n_estimators = 5, # Reduced for a quick example
    threshold_strategy = "youden",
    positive_label_value = 1,
    negative_label_value = 0,
    new_positive_label = "Case",
    new_negative_label = "Control"
  )
  print_model_summary_dia("Bagging (RF)", bagging_rf_results)
}
}
}
\seealso{
\code{\link{initialize_modeling_system_dia}}, \code{\link{evaluate_model_dia}}
}
