% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mindepth.R
\name{plot_mindepth}
\alias{plot_mindepth}
\title{Compute the average minimal depth statistic}
\usage{
plot_mindepth(var_depth_obj, plot_level = c("predictor", "feature"))
}
\arguments{
\item{var_depth_obj}{Object from \code{var_depth} function}

\item{plot_level}{Compute the statistic at predictor (\code{plot_level}="predictor") or feature (\code{plot_level}="feature") level}
}
\value{
Display the minimal depth for each predictor/feature
}
\description{
Compute the average minimal depth statistic
}
\examples{
\donttest{
data(pbc2)

# Sample 100 subjects
set.seed(1234)
id <- unique(pbc2$id)
id_sample <- sample(id, 100)
id_row <- which(pbc2$id\%in\%id_sample)

pbc2_train <- pbc2[id_row,]

timeData_train <- pbc2_train[,c("id","time",
                                "serBilir","SGOT",
                                "albumin","alkaline")]

# Create object with longitudinal association for each predictor
timeVarModel <- list(serBilir = list(fixed = serBilir ~ time,
                                     random = ~ time),
                     SGOT = list(fixed = SGOT ~ time + I(time^2),
                                 random = ~ time + I(time^2)),
                     albumin = list(fixed = albumin ~ time,
                                    random = ~ time),
                     alkaline = list(fixed = alkaline ~ time,
                                     random = ~ time))

# Build fixed data
fixedData_train <- unique(pbc2_train[,c("id","age","drug","sex")])

# Build outcome data
Y <- list(type = "surv",
          Y = unique(pbc2_train[,c("id","years","event")]))

# Run DynForest function
res_dyn <- DynForest(timeData = timeData_train, fixedData = fixedData_train,
                     timeVar = "time", idVar = "id",
                     timeVarModel = timeVarModel, Y = Y,
                     ntree = 50, nodesize = 5, minsplit = 5,
                     cause = 2, ncores = 2, seed = 1234)

# Run var_depth function
res_varDepth <- var_depth(res_dyn)

# Plot minimal depth
plot_mindepth(res_varDepth, plot_level = "feature")

}

}
\seealso{
\code{\link{DynForest} \link{var_depth} \link{plot_VIMP} \link{plot_gVIMP}}
}
