% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotIndication}
\alias{plotIndication}
\title{Generate a plot visualisation (ggplot2) from the output of
summariseIndication}
\usage{
plotIndication(
  result,
  facet = cdm_name + cohort_name ~ window_name,
  colour = "variable_level"
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}
}
\value{
A ggplot2 object
}
\description{
Generate a plot visualisation (ggplot2) from the output of
summariseIndication
}
\examples{
\donttest{
cdm <- mockDrugUtilisation()

indications <- list("headache" = 378253, "asthma" = 317009)
cdm <- CDMConnector::generateConceptCohortSet(cdm, indications, "indication_cohorts")

cdm <- generateIngredientCohortSet(
  cdm = cdm, name = "drug_cohort", ingredient = "acetaminophen"
)

result <- cdm$drug_cohort |>
  summariseIndication(
    indicationCohortName = "indication_cohorts",
    unknownIndicationTable = "condition_occurrence",
    indicationWindow = list(c(-Inf, 0), c(-365, 0))
  )

plotIndication(result)
}

}
