driftBursts = function(timestamps = NULL, logPrices, testTimes = seq(34200, 57600, 60),
                       preAverage = 5, ACLag = -1L, meanBandwidth = 300L, 
                       varianceBandwidth = 900L, realTime = FALSE,
                       parallelize = FALSE, nCores = NA, warnings = TRUE){

  #########  Initialization  ############
  k                    = preAverage 
  vX                   = diff(logPrices)
  iT                   = length(logPrices)
  xts                  = FALSE
  pad = removedFromEnd = 0
  tt                   = testTimes #For returning when we have to pad.
  #########  init end  ############
  
  ###Checks###
  if (meanBandwidth<0 | meanBandwidth %% 1 != 0) {
    stop("meanBandwidth must be a positive integer")
  }
  if(varianceBandwidth<0 | varianceBandwidth %% 1 != 0){
    stop("varianceBandwidth must be a positive integer")
  }
  if(ACLag !=-1 && ACLag%%1!=0 | -1>ACLag | ACLag == 1){
    stop("ACLag must be a positive integer greater than or equal to 1, or -1. \n
         The standard of -1 designates usage of an automated lag selection algorithm.")
    #Specifically Newey-West 1994
  }
  if(preAverage <=0 | preAverage%%1!=0 ){
    stop("preAverage must be a positive integer. No preaveraging is done when preAverage = 1.")
  }
  if(inherits(logPrices, "xts")){
    tz              = tzone(logPrices)
    timestamps      = index(logPrices)
    timestamps      = as.numeric(timestamps) - (.indexDate(logPrices)[1] * 86400)
    vIndex          = as.POSIXct((.indexDate(logPrices)[1] * 86400) + testTimes, origin = "1970-01-01")
    logPrices       = as.numeric(t(logPrices)) ##need to transpose, otherwise the program will crash.
    vX              = as.numeric(vX)[-1] ### need to remove first entry because diff() on an xts object produces NA in first entry.
    xts             = TRUE
  }
  if((anyNA(timestamps) & !is.null(timestamps)) | anyNA(logPrices) | anyNA(testTimes)){
    stop("NA's in timestamps, logPrices or testTimes - might cause crashes and are thus disallowed")
  }
  if((length(timestamps) != length(logPrices) & !is.null(timestamps))){
    stop("timestamps and logPrices input not of same length, to prevent crashing this is not allowed.")
  }
  if((is.na(nCores) | nCores %% 1 != 0) & parallelize){
    if(warnings){
    warning("No iCores argument was provided, or the provided nCores argument is not an integer.\n
             Sequential evaluation is used.")
  }
    parallelize = FALSE
  }
  if(15 <= max(diff(timestamps))/60){
    stop("There is a period of greater than 15 minutes with no trades.\n
          This causes fatal errors (and crashes if paralellized) and is thus disallowed")
  }
  if(min(timestamps) > min(testTimes[-1]) | sum(testTimes[2]>timestamps) <= 2*k){
    testTimes = testTimes[-2]
    pad = 1
    while(min(timestamps) > min(testTimes[-1]) | sum(testTimes[2]>timestamps) <= 2*k){
      testTimes = testTimes[-2] 
      pad = pad + 1
    }
    if(warnings){
      if(!realTime){
    warning(paste("\nThe first testing timestamps is before any observations. This causes fatal errors (and crashes if paralellized).",
                  "\nItereatively removing first testing timestamps until this is no longer the case.",
                  "\nRemoved the first", pad, "entries from testTimes and replacing with a 0\n"))
      } else {
    warning(paste("\nThe first testing timestamps is before enough observations to do the first pre-averaging. This causes crashes (and crashes if paralellized).",
                  "\nItereatively removing first testing timestamps until this is no longer the case.",
                  "\nRemoved the first", pad, "entries from testTimes and replacing with a 0\n"))
        }
    }
  }
  if(max(testTimes)>max(timestamps) + 900){
    testTimes = testTimes[-length(testTimes)]
    removedFromEnd = 1
    while(max(testTimes)>max(timestamps) + 900){
      testTimes = testTimes[-length(testTimes)]  
      removedFromEnd = removedFromEnd + 1
    }
    if(warnings){
      warning(paste("\nThe last testing timestamps is more than 15 minutes after the last trade, this may cause fatal errors or crashes.",
                    "\nIteratively removing the last testing timestamps until this is no longer the case.",
                    "\nRemoved the last", removedFromEnd, "entries from testTimes\n"))
      
    }
    
  }
  ###Checks end###
  
  if(!realTime){
    vpreAveraged         = rep(0, iT - 1)
    vpreAveraged[(k*2 - 1):(iT - 1)] = cfilter(x = logPrices, c(rep(1,k),rep( -1,k)))[k:(iT - k)]
    if(parallelize & !is.na(nCores)){ #Parallel evaluation or not?
      lDriftBursts = DriftBurstLoopCPAR(c(0,vpreAveraged), c(0,vX), timestamps, testTimes, meanBandwidth, 
                                       varianceBandwidth, preAverage, ACLag, nCores)
    }else{
      lDriftBursts = DriftBurstLoopC(c(0,vpreAveraged), c(0,vX), timestamps, testTimes, meanBandwidth, 
                                    varianceBandwidth, preAverage, ACLag)  
    }
  }else{
    if(parallelize & !is.na(nCores)){ #Parallel evaluation or not?
      lDriftBursts = DriftBurstRealTimeCPAR(vLogPrices = logPrices, diffedlogprices = c(0,vX), vTime = timestamps, 
                                            vTesttime = testTimes, iMeanBandwidth = meanBandwidth,
                                            iVarBandwidth = varianceBandwidth, iPreAverage = k, iAcLag = ACLag, iCores = nCores)
    } else {
      lDriftBursts = DriftBurstRealTimeC(vLogPrices = logPrices, diffedlogprices = c(0,vX), vTime = timestamps, 
                                           vTesttime = testTimes, iMeanBandwidth = meanBandwidth,
                                           iVarBandwidth = varianceBandwidth, iPreAverage = k, iAcLag = ACLag)
    }
  }
  lDriftBursts[["driftBursts"]][1] = 0 
  lDriftBursts[["sigma"]][1]       = 0
  lDriftBursts[["mu"]][1]          = 0
  
  if(pad != 0 | removedFromEnd != 0){
    lDriftBursts[["driftBursts"]] = c(rep(0,pad), lDriftBursts[["driftBursts"]], rep(0,removedFromEnd))
    lDriftBursts[["sigma"]]       = c(rep(0,pad), lDriftBursts[["sigma"]], rep(0,removedFromEnd))
    lDriftBursts[["mu"]]          = c(rep(0,pad), lDriftBursts[["mu"]], rep(0,removedFromEnd))
  }
  
  if(xts){
    lDriftBursts[["driftBursts"]] = xts(lDriftBursts[["driftBursts"]], order.by = vIndex, tz = tz)
    lDriftBursts[["sigma"]]       = xts(lDriftBursts[["sigma"]], order.by = vIndex, tz = tz)
    lDriftBursts[["mu"]]          = xts(lDriftBursts[["mu"]], order.by = vIndex, tz = tz)
  }
  
  lInfo = list("varianceBandwidth" = varianceBandwidth, "meanBandwidth" = meanBandwidth,"preAverage" = preAverage,
               "nObs" = iT, "testTimes" = tt)
  lDriftBursts[["Info"]] = lInfo
  #replace NANs with 0's
  NANS = is.nan(lDriftBursts[["sigma"]])
  lDriftBursts[["driftBursts"]][NANS] = 0
  lDriftBursts[["sigma"]][NANS]       = 0
  
  class(lDriftBursts) = c("DBH", "list")
  return(lDriftBursts)
}

drift_bursts = function(time = NULL, logprices, testtimes = seq(34200, 57600, 60),
                        PreAverage = 5, AcLag = -1L, Mean_bandwidth = 300L, 
                        Variance_bandwidth = 900L, bParallelize = FALSE, iCores = NA, warnings = TRUE){
  .Deprecated("driftBursts", msg = "This package has moved to camelCase, drift_bursts have been renamed to driftBursts and arguments have been renamed")
  return(driftBursts(time, logprices, testtimes, PreAverage, AcLag, Mean_bandwidth, Variance_bandwidth,
                     bParallelize, iCores, warnings))
}
