% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_spec_tables.R
\name{generate_spec_tables}
\alias{generate_spec_tables}
\title{Generate Species Tables}
\usage{
generate_spec_tables(clusterised_object, min_individuals = 0, min_species = 0)
}
\arguments{
\item{clusterised_object}{An object created by the clusterise_sites function.}

\item{min_individuals}{The minimum number of individuals in each table}

\item{min_species}{The minimum number of species in each table.}
}
\value{
A list of species counts tables.
}
\description{
Generate a list of tables for species counts from the input clusterised object.
}
\examples{
# generate species count tables with a minimum of 30 individuals from 5 species
Colombia_Caquetá_dataframe <- subset(Colombia, stateProvince == "Caquetá")

clusterised_Caquetá <- clusterise_sites(dataframe = Colombia_Caquetá_dataframe,
                                       cluster_min_length = 30,
                                       group_radius = 20000
)

Spec_Tables_Caquetá <- generate_spec_tables(

 clusterised_object = clusterised_Caquetá,
 min_individuals = 30,
 min_species = 5

)

print(Spec_Tables_Caquetá$`5.2016-03-22`)
print(Spec_Tables_Caquetá$`5.2016-03-29`)
print(Spec_Tables_Caquetá$`5.2016-03-30`)
print(Spec_Tables_Caquetá$`5.2016-04-13`)
}
