% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCOMP.R
\name{p_PCOMP}
\alias{p_PCOMP}
\alias{E_PCOMP}
\alias{V_PCOMP}
\alias{VaR_PCOMP}
\alias{TVaR_PCOMP}
\title{Compound Poisson Distribution}
\usage{
p_PCOMP(
  x,
  lambda,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  k0,
  distr_severity = "Gamma"
)

E_PCOMP(
  lambda,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  distr_severity = "Gamma"
)

V_PCOMP(
  lambda,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  distr_severity = "Gamma"
)

VaR_PCOMP(
  kap,
  lambda,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  k0,
  distr_severity = "Gamma"
)

TVaR_PCOMP(
  kap,
  lambda,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  vark,
  k0,
  distr_severity = "Gamma"
)
}
\arguments{
\item{x}{quantile.}

\item{lambda}{Rate parameter \eqn{\lambda}{lambda}.}

\item{shape}{shape parameter \eqn{\alpha}{alpha}, must be positive integer.}

\item{rate}{\eqn{\beta}{beta} is the rate parameter, must be positive.}

\item{scale}{alternative parameterization to rate parameter, scale = 1 / rate.}

\item{k0}{point up to which to sum the distribution for the approximation.}

\item{distr_severity}{Choice of severity distribution.
\itemize{
 \item{"gamma"} (default)
 \item{"lognormal"} only for the expected value and variance.
}}

\item{kap}{probability.}

\item{vark}{Value-at-Risk (VaR) calculated at the given probability kap.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{p_PCOMP}}}{ gives the cumulative density function.}
 \item{\code{\link{E_PCOMP}}}{ gives the expected value.}
 \item{\code{\link{V_PCOMP}}}{ gives the variance.}
 \item{\code{\link{TVaR_PCOMP}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_PCOMP}}}{ gives the Value-at-Risk.}
 }
 Returned values are approximations for the cumulative density function,
 TVaR, and VaR.
}
\description{
Computes various risk measures (mean, variance, Value-at-Risk (VaR),
  and Tail Value-at-Risk (TVaR)) for the compound Poisson distribution.
}
\details{
The compound Binomial Distribution with parameters ... has density ....
}
\examples{
p_PCOMP(x = 2, lambda = 2, shape = log(1000) - 0.405,
          rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")

E_PCOMP(lambda = 2, shape = log(1000) - 0.405, rate = 0.9^2,
          distr_severity = "Lognormale")

V_PCOMP(lambda = 2, shape = log(1000) - 0.405, rate = 0.9^2,
          distr_severity = "Lognormale")

VaR_PCOMP(kap = 0.9, lambda = 2, shape = log(1000) - 0.405,
            rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")

vark_calc <- VaR_PCOMP(kap = 0.9, lambda = 2, shape = 0.59,
            rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")
TVaR_PCOMP(kap = 0.9, lambda = 2, shape = 0.59, rate = 0.9^2,
            vark = vark_calc, k0 = 1E2, distr_severity = "Gamma")

}
