% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Etronq_binom.R
\name{Etronq_binom}
\alias{Etronq_binom}
\title{Truncated mean of the Binomial distribution}
\usage{
Etronq_binom(d, size, prob, less.than.d = TRUE)
}
\arguments{
\item{d}{cut-off value.}

\item{size}{Number of trials (0 or more).}

\item{prob}{Probability of success on each trial.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_binom}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{E_binom}}}{ gives the expected value.}
 \item{\code{\link{V_binom}}}{ gives the variance.}
 \item{\code{\link{Etronq_binom}}}{ gives the truncated mean.}
 \item{\code{\link{TVaR_binom}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{VaR_binom}}}{ gives the Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Truncated mean of the Binomial distribution
  with size \eqn{n}{n} and probability of success \eqn{p}{p}.
}
\details{
The Binomial distribution with probability of success \eqn{p}{p} for \eqn{n}{n} trials
  has probability mass function :
  \deqn{Pr(X = k) = \left(\frac{n}{k}\right) p^n (1 - p)^{n - k}}{Pr(X = k) = n!/(k!(n - k)!) p^n(1 - p)^(n - k)}
  for \eqn{k = 0, 1, 2, \dots, n}{k = 0, 1, 2, ..., n}, \eqn{p \in [0, 1]}{0 <= p <= 1}, and \eqn{n > 0}{n > 0}
}
\examples{

Etronq_binom(d = 2, size = 3, prob = 0.5)
Etronq_binom(d = 0, size = 3, prob = 0.5, less.than.d = FALSE)

}
\seealso{
Other Binomial Distribution: 
\code{\link{E_binom}()},
\code{\link{MGF_binom}()},
\code{\link{PGF_binom}()},
\code{\link{TVaR_binom}()},
\code{\link{V_binom}()},
\code{\link{VaR_binom}()}
}
\concept{Binomial Distribution}
