% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funs.R
\name{hist.DiscreteFDR}
\alias{hist.DiscreteFDR}
\title{Histogram of Raw P-Values}
\usage{
\method{hist}{DiscreteFDR}(x, breaks = "FD", plot = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{DiscreteFDR}.}

\item{breaks}{as in \code{\link{hist}}; here, the Friedman-Diaconis algorithm
(\code{"FD"}) is used as default.}

\item{plot}{a boolean; if \code{TRUE} (the default), a histogram is plotted,
otherwise a list of breaks and counts is returned.}

\item{...}{further arguments to \code{\link{hist}} or \code{\link{plot.histogram}},
respectively.}
}
\value{
An object of class \code{histogram}.
}
\description{
Computes a histogram of the raw p-values of a \code{DiscreteFDR} object.
}
\details{
This method simply calls \code{\link{hist}} and passes the raw p-values of the object.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Compute p-values and their supports of Fisher's exact test
test.result <- generate.pvalues(df, "fisher")
raw.pvalues <- test.result$get_pvalues()
pCDFlist <- test.result$get_pvalue_supports()

DBH <- DBH(raw.pvalues, pCDFlist)
hist(DBH)

}
