#'DiscreteFDR
#'
#'@description
#' This package implements the [HSU], [HSD],
#' [AHSU], [AHSD] and [HBR-lambda] procedures for
#' discrete tests (see References). 
#'
#'@docType package
#'@import Rcpp
#'@useDynLib DiscreteFDR
#'@name DiscreteFDR
#'
#'@details
#' The functions are reorganized from the reference paper in the following way.
#' \code{\link{discrete.BH}} (for Discrete Benjamini-Hochberg) implements
#' [HSU], [HSD], [AHSU] and [AHSD] and \code{\link{DBR}} (for Discrete 
#' Blanchard-Roquain) implements [HBR-lambda]. \code{\link{DBH}} and \code{\link{ADBH}}
#' are wrappers for \code{\link{discrete.BH}} to access [HSU] and [HSD], as well as
#' [AHSU] and [AHSD] directly. Their main arguments are a vector
#' of raw observed p-values, and a list
#' of the same length, which elements are the discrete supports
#' of the CDFs of the p-values.
#' 
#' The function \code{\link{fisher.pvalues.support}} allows to compute
#' such p-values and support in the framework of a Fisher's
#' exact test of association. It has been inspired by an help
#' page of the package \code{\link[discreteMTP]{discreteMTP}}.
#' 
#' The function \code{\link{fast.Discrete}} is a wrapper for \code{\link{fisher.pvalues.support}}
#' and \code{\link{discrete.BH}} which allows to apply discrete procedures
#' directly to a data set of contingency tables.
#' 
#' We also provide the \code{\link{amnesia}} data set, used in 
#' our examples and in our paper. It is basically the \code{\link[discreteMTP]{amnesia}} data set
#' of package \code{\link[discreteMTP]{discreteMTP}}, but slightly reformatted (the difference lies in column 3).
#' 
#' No other function of the package should
#' be used, they are only internal functions called
#' by the main ones.
#' 
#'@section References:
#' Döhler, S., Durand, G., & Roquain, E. (2018). New FDR bounds for discrete and heterogeneous tests.
#' \emph{Electronic Journal of Statistics}, \emph{12}(1), 1867-1900.
#' \doi{10.1214/18-EJS1441}
"_PACKAGE"