% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dGGEO.R
\name{dGGEO}
\alias{dGGEO}
\alias{pGGEO}
\alias{rGGEO}
\alias{qGGEO}
\title{The GGEO distribution}
\usage{
dGGEO(x, mu = 0.5, sigma = 1, log = FALSE)

pGGEO(q, mu = 0.5, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rGGEO(n, mu = 0.5, sigma = 1)

qGGEO(p, mu = 0.5, sigma = 1, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x, q}{vector of (non-negative integer) quantiles.}

\item{mu}{vector of the mu parameter.}

\item{sigma}{vector of the sigma parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X <= x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}

\item{p}{vector of probabilities.}
}
\value{
\code{dGGEO} gives the density, \code{pGGEO} gives the distribution
function, \code{qGGEO} gives the quantile function, \code{rGGEO}
generates random deviates.
}
\description{
These functions define the density, distribution function, quantile
function and random generation for the Generalized Geometric distribution
with parameters \eqn{\mu} and \eqn{\sigma}.
}
\details{
The GGEO distribution with parameters \eqn{\mu} and \eqn{\sigma}
has a support 0, 1, 2, ... and mass function given by

\eqn{f(x | \mu, \sigma) = \frac{\sigma \mu^x (1-\mu)}{(1-(1-\sigma) \mu^{x+1})(1-(1-\sigma) \mu^{x})}}

with \eqn{0 < \mu < 1} and \eqn{\sigma > 0}. If \eqn{\sigma=1}, the GGEO distribution
reduces to the geometric distribution with success probability \eqn{1-\mu}.

Note: in this implementation we changed the original parameters
\eqn{\theta} for \eqn{\mu} and \eqn{\alpha} for \eqn{\sigma},
we did it to implement this distribution within gamlss framework.
}
\examples{
# Example 1
# Plotting the mass function for different parameter values

x_max <- 80
probs1 <- dGGEO(x=0:x_max, mu=0.5, sigma=10)
probs2 <- dGGEO(x=0:x_max, mu=0.7, sigma=30)
probs3 <- dGGEO(x=0:x_max, mu=0.9, sigma=50)

# To plot the first k values
plot(x=0:x_max, y=probs1, type="o", lwd=2, col="dodgerblue", las=1,
     ylab="P(X=x)", xlab="X", main="Probability for GGEO",
     ylim=c(0, 0.20))
points(x=0:x_max, y=probs2, type="o", lwd=2, col="tomato")
points(x=0:x_max, y=probs3, type="o", lwd=2, col="green4")
legend("topright", col=c("dodgerblue", "tomato", "green4"), lwd=3,
       legend=c("mu=0.5, sigma=10",
                "mu=0.7, sigma=30",
                "mu=0.9, sigma=50"))

# Example 2
# Checking if the cumulative curves converge to 1

x_max <- 10
plot_discrete_cdf(x=0:x_max,
                  fx=dGGEO(x=0:x_max, mu=0.3, sigma=15),
                  col="dodgerblue",
                  main="CDF for GGEO",
                  lwd= 3)
legend("bottomright", legend="mu=0.3, sigma=15", col="dodgerblue",
       lty=1, lwd=2, cex=0.8)

plot_discrete_cdf(x=0:x_max,
                  fx=dGGEO(x=0:x_max, mu=0.5, sigma=30),
                  col="tomato",
                  main="CDF for GGEO",
                  lwd=3)
legend("bottomright", legend="mu=0.5, sigma=30",
       col="tomato", lty=1, lwd=2, cex=0.8)

plot_discrete_cdf(x=0:x_max,
                  fx=dGGEO(x=0:x_max, mu=0.5, sigma=50),
                  col="green4",
                  main="CDF for GGEO",
                  lwd=3)
legend("bottomright", legend="mu=0.5, sigma=50",
       col="green4", lty=1, lwd=2, cex=0.8)

# Example 3
# Comparing the random generator output with
# the theoretical probabilities

x_max <- 15
probs1 <- dGGEO(x=0:x_max, mu=0.5, sigma=5)
names(probs1) <- 0:x_max

x <- rGGEO(n=1000, mu=0.5, sigma=5)
probs2 <- prop.table(table(x))

cn <- union(names(probs1), names(probs2))
height <- rbind(probs1[cn], probs2[cn])
nombres <- cn
mp <- barplot(height, beside=TRUE, names.arg=nombres,
              col=c("dodgerblue3", "firebrick3"), las=1,
              xlab="X", ylab="Proportion")
legend("topright",
       legend=c("Theoretical", "Simulated"),
       bty="n", lwd=3,
       col=c("dodgerblue3","firebrick3"), lty=1)

# Example 4
# Checking the quantile function

mu <- 0.5
sigma <- 5
p <- seq(from=0, to=1, by=0.01)
qxx <- qGGEO(p=p, mu=mu, sigma=sigma, lower.tail=TRUE, log.p=FALSE)
plot(p, qxx, type="s", lwd=2, col="green3", ylab="quantiles",
     main="Quantiles of GGEO(mu=0.5, sigma=0.5)")

}
\references{
\insertRef{gomez2010}{DiscreteDists}
}
\seealso{
\link{GGEO}.
}
\author{
Valentina Hurtado Sepulveda, \email{vhurtados@unal.edu.co}
}
