#' @title
#' Amnesia and other drug reactions in the MHRA pharmacovigilance spontaneous
#' reporting system
#'
#' @docType data
#'
#' @description
#' For each of 2,446 drugs in the MHRA database (column 1), the number of cases
#' with amnesia as an adverse event (column 2), and the number of cases with
#' other adverse event for this drug (column 3). In total, 684,652 adverse drug
#' reactions were reported, among them 2,044 cases of amnesia.
#'
#' @usage data("amnesia")
#'
#' @format
#' \code{amnesia} is a \code{data.frame} with 2,446 rows representing drugs
#' with the following two columns:
#' \describe{
#'   \item{AmnesiaCases}{Number of the amnesia cases reported for the drug.}
#'   \item{OtherAdverseCases}{Number of other adverse drug reactions reported
#'                            for the drug.}
#' }
#' Thus, each line describes a 2x2 table, e.g.:
#' \tabular{rcc}{
#'   1-ANDROSTENEDIOL    \tab This drug      \tab All other drugs\cr
#'   Amnesia cases       \tab \eqn{X_{i, 1}} \tab 2,044   - \eqn{X_{i, 1}}\cr
#'   Other adverse cases \tab \eqn{X_{i, 2}} \tab 682,648 - \eqn{X_{i, 2}}
#' }
#'
#' @details
#' The data was collected from the Drug Analysis Prints published
#' by the Medicines and Healthcare products Regulatory Agency (MHRA),
#' by Heller & Gur. See references for more details.

#' @source
#' \href{https://yellowcard.mhra.gov.uk/idaps}{Drug Analysis Prints on MHRA site}
#'
#' @note
#' The original \code{amnesia} dataset has been taken from the
#' \code{discreteMTP} package, which is no longer available on CRAN. It has been
#' reformatted such that the names in first column are now row descriptions;
#' this way, the actual contents of the table are purely numeric.
#'
#' @references
#' R. Heller and H. Gur (2011). False discovery rate controlling procedures for
#'    discrete tests. arXiv pre-print arXiv:1112.4627v2
#'    \href{https://arxiv.org/abs/1112.4627v2}{link}.
#'
#' @keywords datasets
"amnesia"

#' @rdname amnesia
#'
#' @usage data("amnesia_four_columns")
#'
#' @format
#' \code{amnesia_four_columns} is a \code{data.frame} with 2,446 rows
#' representing drugs with the following four columns:
#' \describe{
#'   \item{AmnesiaCases.ThisDrug}{Number of the amnesia cases reported for the
#'                                drug.}
#'   \item{AmnesiaCases.AllOtherDrugs}{Number of the amnesia cases reported for
#'                                     all other drugs.}
#'   \item{OtherAdverseCases.ThisDrug}{Number of other adverse drug reactions
#'                                     reported for the drug.}
#'   \item{OtherAdverseCases.AllOtherDrugs}{Number of other adverse drug
#'                                          reactions reported for all other
#'                                          drugs.}
#' }
#' Thus, each line describes a 2x2 table:
#' \tabular{rcc}{
#'   1-ANDROSTENEDIOL    \tab This drug      \tab All other drugs\cr
#'   Amnesia cases       \tab \eqn{X_{i, 1}} \tab \eqn{X_{i, 3}}\cr
#'   Other adverse cases \tab \eqn{X_{i, 2}} \tab \eqn{X_{i, 4}}
#' }
"amnesia_four_columns"
