% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_alpha_centrality.R
\name{get_alpha_centrality}
\alias{get_alpha_centrality}
\title{Get the alpha centrality for all nodes}
\usage{
get_alpha_centrality(
  graph,
  alpha = 1,
  exo = 1,
  weights_attr = NULL,
  tol = 1e-07
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{alpha}{the parameter that specifies the relative importance of
endogenous versus exogenous factors in the determination of centrality.}

\item{exo}{the exogenous factors, in most cases this is either a constant
(which applies the same factor to every node), or a vector giving the
factor for every node.}

\item{weights_attr}{an optional name of the edge attribute to use in the
adjacency matrix. If \code{NULL} then, if it exists, the \code{weight} edge
attribute of the graph will be used. Failing that, the standard adjacency
matrix will be used in calculations.}

\item{tol}{the tolerance for near-singularities during matrix inversion.
The default value is set to \code{1e-7}.}
}
\value{
A data frame with alpha centrality scores for each of the nodes.
}
\description{
Get the alpha centrality values for all nodes in the graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 10,
    m = 12,
    set_seed = 23)

# Get the alpha centrality scores
# for all nodes
graph \%>\%
  get_alpha_centrality()

# Add the alpha centrality
# scores to the graph as a node
# attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_alpha_centrality(.))

# Display the graph's node
# data frame
graph \%>\% get_node_df()

}
