% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_edge_df.R
\name{create_edge_df}
\alias{create_edge_df}
\title{Create an edge data frame}
\usage{
create_edge_df(from, to, rel = NULL, ...)
}
\arguments{
\item{from}{A vector of node ID values from which edges are outbound. The
vector length must equal that of the \code{to} vector.}

\item{to}{A vector of node ID values to which edges are incoming. The vector
length must equal that of the \code{from} vector.}

\item{rel}{An optional \code{rel} label for each edge.}

\item{...}{One or more vectors for associated edge attributes.}
}
\value{
An edge data frame (edf).
}
\description{
Combine several vectors for edges and their attributes into a data frame,
which can be combined with other similarly-generated data frames, or, added
to a graph object. An edge data frame, or edf, has at least the following
columns:
}
\details{
\itemize{
\item \code{id} (of type \code{integer})
\item \code{from} (of type \code{integer})
\item \code{to} (of type \code{integer})
\item \code{rel} (of type \code{character})
}

An arbitrary number of additional columns containing aesthetic or data
attributes can be part of the edf, so long as they follow the aforementioned
columns.
}
\examples{
# Create a simple edge data frame (edf) and
# view the results
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "a")

# Display the edge data frame
edf

# Create an edf with additional edge
# attributes (where their classes will
# be inferred from the input vectors)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "a",
    length = c(50, 100, 250),
    color = "green",
    width = c(1, 5, 2))

# Display the edge data frame
edf

}
