% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_min_eccentricity.R
\name{get_min_eccentricity}
\alias{get_min_eccentricity}
\title{Get the minimum graph eccentricity}
\usage{
get_min_eccentricity(graph, direction = "all")
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{direction}{using \code{all} (the default), the
search will ignore edge direction while traversing
through the graph. With \code{out}, measurements of
paths will be from a node whereas with \code{in},
measurements of paths will be to a node.}
}
\value{
a single numeric value representing the
minimum eccentricity of the graph.
}
\description{
Get the radius of a graph, which is
the smallest eccentricity in the graph. The graph
eccentricity of a node is its shortest path from
the farthest other node in the graph.
}
\examples{
# Create a cycle graph
graph <-
  create_graph() \%>\%
  add_cycle(n = 5)

# Determine the graph's minimum
# eccentricity
get_min_eccentricity(graph)
#> [1] 2

# Create a full graph and then
# get the minimum eccentricity
# value for that
create_graph() \%>\%
  add_full_graph(n = 10) \%>\%
  get_min_eccentricity()
#> [1] 1
}
