% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_jaccard_similarity.R
\name{get_jaccard_similarity}
\alias{get_jaccard_similarity}
\title{Get Jaccard similarity coefficient scores}
\usage{
get_jaccard_similarity(graph, nodes = NULL, direction = "all",
  round_to = 3)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{nodes}{an optional vector of node IDs to
consider for Jaccard similarity scores. If not
supplied, then similarity scores will be provided
for every pair of nodes in the graph.}

\item{direction}{using \code{all} (the default), the
function will ignore edge direction when
determining scores for neighboring nodes. With
\code{out} and \code{in}, edge direction for
neighboring nodes will be considered.}

\item{round_to}{the maximum number of decimal places
to retain for the Jaccard similarity coefficient
scores. The default value is \code{3}.}
}
\value{
a matrix with Jaccard similarity values
for each pair of nodes considered.
}
\description{
Get the Jaccard similarity coefficient
scores for one or more nodes in a graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Get the Jaccard similarity values for
# nodes `5`, `6`, and `7`
get_jaccard_similarity(graph, nodes = 5:7)
#>       5     6     7
#> 5 1.000 0.333 0.286
#> 6 0.333 1.000 0.375
#> 7 0.286 0.375 1.000
}
