% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_node.R
\name{delete_node}
\alias{delete_node}
\title{Delete a node from an existing graph object}
\usage{
delete_node(graph, node)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node}{a node ID for the node to be deleted
from the graph.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class
\code{dgr_graph}, delete an existing node by
specifying its node ID.
}
\examples{
# Create a graph with 5 nodes and
# edges between each in a path
graph <-
  create_graph() \%>\%
  add_path(n = 5)

# Delete node with ID `3`
graph <- delete_node(graph, node = 3)

# Verify that the node with ID `3`
# is no longer in the graph
get_node_ids(graph)
#> [1] 1 2 4 5

# Also note that edges are removed
# since there were edges between the
# removed node to and from other nodes
get_edges(graph)
#> [1] "1->2" "4->5"
}
