% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_closeness.R
\name{get_closeness}
\alias{get_closeness}
\title{Get closeness centrality values}
\usage{
get_closeness(graph, direction = "all")
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{direction}{using \code{all} (the default), the
search will ignore edge direction while traversing
through the graph. With \code{out}, measurements of
paths will be from a node whereas with \code{in},
measurements of paths will be to a node.}
}
\value{
a data frame with closeness values for
each of the nodes.
}
\description{
Get the closeness centrality values
for all nodes in a graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    10, 22, set_seed = 1)

# Get closeness values for all nodes in the graph
get_closeness(graph)
#>    id  closeness
#> 1   1 0.07142857
#> 2   2 0.07692308
#> 3   3 0.06666667
#> 4   4 0.07142857
#> 5   5 0.08333333
#> 6   6 0.05882353
#> 7   7 0.08333333
#> 8   8 0.07692308
#> 9   9 0.06666667
#> 10 10 0.05882353

# Add the closeness values to the graph
# as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    get_closeness(.))
}

