% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_count.R
\name{graph_count}
\alias{graph_count}
\title{Count graphs in a graph series object}
\usage{
graph_count(graph_series)
}
\arguments{
\item{graph_series}{a graph series object of type
\code{dgr_graph_1D}}
}
\value{
a numeric vector representing a count of
graphs in a graph series object.
}
\description{
Counts the total number of graphs in a
graph series object.
}
\examples{
library(magrittr)

# Create three graphs
graph_1 <-
  create_graph() \%>\%
  add_node("a") \%>\%
  add_node("b") \%>\%
  add_node("c") \%>\%
  add_edge("a", "c") \%>\%
  add_edge("a", "b") \%>\%
  add_edge("b", "c")

graph_2 <-
  graph_1 \%>\%
  add_node("d") \%>\%
  add_edge("d", "c")

graph_3 <-
  graph_2 \%>\%
  add_node("e") \%>\%
  add_edge("e", "b")

# Create an empty graph series and add
# the graphs
series <-
  create_series() \%>\%
  add_to_series(graph_1, .) \%>\%
  add_to_series(graph_2, .) \%>\%
  add_to_series(graph_3, .)

# Count the number of graphs in the graph series
graph_count(series)
#> [1] 3
}

