% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediation_analysis_designer.R
\name{mediation_analysis_designer}
\alias{mediation_analysis_designer}
\title{Create a design for mediation analysis}
\usage{
mediation_analysis_designer(
  N = 200,
  a = 1,
  b = 0.4,
  c = 0,
  d = 0.5,
  rho = 0,
  args_to_fix = NULL
)
}
\arguments{
\item{N}{An integer. Size of sample.}

\item{a}{A number. Parameter governing effect of treatment (Z) on mediator (M).}

\item{b}{A number. Effect of mediator (M) on outcome (Y) when Z = 0.}

\item{c}{A number. Interaction between mediator (M) and (Z) for outcome (Y).}

\item{d}{A number. Direct effect of treatment (Z) on outcome (Y), when M = 0.}

\item{rho}{A number in [-1,1]. Correlation between mediator (M) and outcome (Y) error terms. Non zero correlation implies a violation of sequential ignorability.}

\item{args_to_fix}{A character vector. Names of arguments to be args_to_fix in design.}
}
\value{
A mediation analysis design.
}
\description{
A mediation analysis design that examines the effect of treatment (Z) on mediator (M) and the effect of mediator (M) on outcome (Y) (given Z=0) 
as well as direct effect of treatment (Z) on outcome (Y) (given M=0). Analysis is implemented using an interacted regression model. 
Note this model is not guaranteed to be unbiased despite randomization of Z because of possible violations of sequential ignorability.
}
\details{
See \href{https://declaredesign.org/r/designlibrary/articles/mediation_analysis.html}{vignette online}.
}
\examples{
# Generate a mediation analysis design using default arguments:
mediation_1 <- mediation_analysis_designer()
draw_inquiries(mediation_1)
\dontrun{
diagnose_design(mediation_1, sims = 1000)
}

# A design with a violation of sequential ignorability and heterogeneous effects:
mediation_2 <- mediation_analysis_designer(a = 1, rho = .5, c = 1, d = .75)
draw_inquiries(mediation_2)
\dontrun{
diagnose_design(mediation_2, sims = 1000)
}

}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{experiment}
\concept{mediation}
