% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat.R
\name{sumstat}
\alias{sumstat}
\alias{.sumstat}
\alias{.sumstat.default}
\alias{.sumstat.factor}
\alias{.sumstat.ordered}
\alias{.sumstat.character}
\alias{.sumstat.logical}
\title{Summary Statistics}
\usage{
.sumstat(x, fmt, ...)

\method{.sumstat}{default}(x, fmt = "\%.2f", ...)

\method{.sumstat}{factor}(x, ...)

\method{.sumstat}{ordered}(x, ...)

\method{.sumstat}{character}(x, ...)

\method{.sumstat}{logical}(x, ...)
}
\arguments{
\item{x}{an R object}

\item{fmt}{(optional) \link[base]{character} scalar, only for function \link{.sumstat.default}, see function \link[base]{sprintf}}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \code{\link[=.sumstat]{.sumstat()}} returns a \link[base]{character} scalar.
}
\description{
Provide the summary statistics of an R object
}
\details{
Function \code{\link[=.sumstat.default]{.sumstat.default()}} accepts all R objects of \link[base]{typeof} \link[base]{double} and \link[base]{integer}.
Statistics of \link[base]{mean}, \link[stats]{sd} and \link[base]{range} are reported.
If the normality assumption via \link[stats]{shapiro.test} is not satisfied, then \link[stats]{median} and \link[stats]{mad} are also reported.
}
\examples{
x = c(rpois(n = 20L, lambda = 2), NA_integer_)
.sumstat(x)

# factor 
x = state.region
x[2L] = NA_integer_
.sumstat(x)

# binary
.sumstat(c(TRUE, FALSE, TRUE, NA))
.sumstat(c(TRUE, FALSE, TRUE))
.sumstat(c(FALSE, FALSE, NA))
.sumstat(c(FALSE, FALSE, FALSE))
.sumstat(c(NA, NA, NA))

}
\keyword{internal}
