/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots;

import edu.cens.spatial.DeducerSpatial;
import edu.cens.spatial.plots.ElementModel;
import edu.cens.spatial.plots.widgets.ParamSpatialVariable;
import edu.cens.spatial.plots.widgets.RPointFunction;
import javax.swing.JDialog;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamCharacter;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.rosuda.deducer.widgets.param.RFunction;
import org.rosuda.deducer.widgets.param.RFunctionDialog;

public class ColoredPointsElementModel
extends ElementModel {
    RFunction rf;

    public ColoredPointsElementModel() {
        this.init();
    }

    public void init() {
        this.rf = new RPointFunction("spatialColoredPoints");
        this.rf.setViewType(null);
        ParamSpatialVariable paramSpatialVariable = new ParamSpatialVariable("color_var");
        paramSpatialVariable.setFormat(ParamSpatialVariable.FORMAT_WITH_DATA_CHARACTER);
        paramSpatialVariable.setTitle("Color");
        this.rf.add((Param)paramSpatialVariable);
        ParamNumeric paramNumeric = new ParamNumeric("pch");
        paramNumeric.setTitle("Type");
        paramNumeric.setLowerBound(0.5);
        paramNumeric.setUpperBound(25.5);
        paramNumeric.setOptions(new String[]{"1.0", "2.0", "3.0", "4.0", "5.0", "6.0", "7.0", "8.0", "9.0", "10.0", "11.0", "12.0", "13.0", "14.0", "15.0", "16.0", "17.0", "18.0", "19.0", "20.0"});
        paramNumeric.setLabels(new String[]{"open circle", "open triangle", "plus", "cross", "open diamond", "open triangle (rev)", "cross square", "star", "plus diamond", "plus circle", "double hourglass", "plus square", "target", "triange square", "solid square", "solid circle", "solid triangle", "solid diamond", "solid circle (big)", "solid circle (small)"});
        paramNumeric.setValue(16.0);
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramNumeric.setRequired(false);
        this.rf.add((Param)paramNumeric);
        paramNumeric = new ParamNumeric("cex");
        paramNumeric.setTitle("Size");
        paramNumeric.setDefaultValue(1.0);
        paramNumeric.setLowerBound(0.0);
        paramNumeric.setValue(1.0);
        this.rf.add((Param)paramNumeric);
        this.rf.add(DeducerSpatial.makeColorScaleParam());
        ParamCharacter paramCharacter = new ParamCharacter("legend.loc");
        paramCharacter.setTitle("Legend location");
        paramCharacter.setOptions(new String[]{"bottomleft", "bottomright", "topleft", "topright"});
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setDefaultValue((Object)"bottomleft");
        paramCharacter.setValue((Object)"bottomleft");
        this.rf.add((Param)paramCharacter);
        paramCharacter = new ParamCharacter("legend.title");
        paramCharacter.setTitle("Legend title");
        this.rf.add((Param)paramCharacter);
        this.iconLocation = "icons/geo_colored_point.png";
        this.name = "Colored";
    }

    public JDialog getView() {
        RFunctionDialog rFunctionDialog = new RFunctionDialog(this.rf);
        rFunctionDialog.setSize(500, 400);
        rFunctionDialog.setRun(false);
        return rFunctionDialog;
    }

    public String getCall() {
        return this.rf.getCall();
    }

    public String checkValid() {
        return this.rf.checkValid();
    }

    public ColoredPointsElementModel clone() {
        ColoredPointsElementModel coloredPointsElementModel = new ColoredPointsElementModel();
        coloredPointsElementModel.rf = (RFunction)this.rf.clone();
        return coloredPointsElementModel;
    }

    public String getDataFrameArgumentName() {
        return ((ParamSpatialVariable)this.rf.get(0)).getData();
    }

    public void setDataFrameArgumentName(String string) {
        ((ParamSpatialVariable)this.rf.get(0)).setData(string);
    }
}

