/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots.components;

import edu.cens.spatial.plots.components.AbstractComponentPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rosuda.deducer.widgets.SingleVariableWidget;
import org.rosuda.deducer.widgets.VariableSelectorWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BubbleComponentPanel
extends AbstractComponentPanel {
    private final VariableSelectorWidget _vsw = new VariableSelectorWidget();
    private final SingleVariableWidget _lat = new SingleVariableWidget("Lat:", this._vsw);
    private final SingleVariableWidget _lon = new SingleVariableWidget("Lon:", this._vsw);
    private final SingleVariableWidget _z = new SingleVariableWidget("Z:", this._vsw);
    private final JTextField _minRadius = new JTextField(8);
    private final JTextField _maxRadius = new JTextField(8);

    @Override
    public void initDefault() {
        this._maxRadius.setText(".1");
        this._minRadius.setText(".05");
    }

    @Override
    public void initFromArgs() {
        this._vsw.setSelectedData((String)this._args.get(k.dat.name()));
        this._lon.setSelectedVariable((String)this._args.get(k.lon.name()));
        this._lat.setSelectedVariable((String)this._args.get(k.lat.name()));
        this._z.setSelectedVariable((String)this._args.get(k.z.name()));
        this._maxRadius.setText((String)this._args.get(k.maxRadius.name()));
        this._minRadius.setText((String)this._args.get(k.minRadius.name()));
    }

    public BubbleComponentPanel(Map<String, String> map) {
        super(map);
        this.initFields();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this._vsw.setBorder(BorderFactory.createLoweredBevelBorder());
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 4;
        this.add((Component)this._vsw, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.add((Component)this._lat, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._lon, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._z, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JPanel(){
            {
                this.setBorder(BorderFactory.createTitledBorder("Radius"));
                this.add(BubbleComponentPanel.this._minRadius);
                this.add(BubbleComponentPanel.this._maxRadius);
            }
        }, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addOkPanel(gridBagConstraints, 4);
    }

    @Override
    boolean doOK() {
        String string = this._vsw.getSelectedData();
        String string2 = this._lat.getSelectedVariable();
        String string3 = this._lon.getSelectedVariable();
        String string4 = this._z.getSelectedVariable();
        if (string == null || string2 == null || string3 == null || string4 == null) {
            return false;
        }
        String string5 = this._minRadius.getText();
        String string6 = this._maxRadius.getText();
        try {
            double d = Double.parseDouble(string5);
            double d2 = Double.parseDouble(string6);
            if (d > d2) {
                String string7 = string5;
                string5 = string6;
                string6 = string7;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        this.putArg(k.dat, string);
        this.putArg(k.lat, string2);
        this.putArg(k.lon, string3);
        this.putArg(k.z, string4);
        this.putArg(k.minRadius, string5);
        this.putArg(k.maxRadius, string6);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum k {
        dat,
        lat,
        lon,
        z,
        minRadius,
        maxRadius;

    }
}

