/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.menu.SubsetDialog;
import org.rosuda.deducer.menu.SubsetPanel;
import org.rosuda.deducer.toolkit.AssumptionIcon;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.SingletonAddRemoveButton;
import org.rosuda.deducer.toolkit.SingletonDJList;
import org.rosuda.deducer.toolkit.VariableSelector;

public class ContingencyDialog
extends JDialog
implements ActionListener {
    private VariableSelector variableSelector;
    private SingletonAddRemoveButton addRemoveStratumButton;
    private IconButton removeColumn;
    private JButton help;
    private SubsetPanel subsetPanel;
    private SingletonDJList stratumList;
    private DJList columnList;
    private DJList rowList;
    private JButton postHoc;
    private JButton statistics;
    private JButton cells;
    private IconButton addColumn;
    private JButton results;
    private IconButton removeRow;
    private IconButton addRow;
    private OkayCancelPanel okCancel;
    private JPanel strataPanel;
    private JPanel columnPanel;
    private JPanel rowPanel;
    private CellOptions cellOpt;
    private StatisticsOptions statOpt;
    private ResultsOptions resultOpt;
    private String rCmd = "";
    private static CellOptions lastCellOpt;
    private static StatisticsOptions lastStatOpt;
    private static ResultsOptions lastResultOpt;
    private static DefaultListModel lastRowModel;
    private static DefaultListModel lastColumnModel;
    private static DefaultListModel lastStratumModel;
    private static String lastDataName;
    private static String lastSubset;

    public ContingencyDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
        this.cellOpt = new CellOptions();
        this.statOpt = new StatisticsOptions();
        this.resultOpt = new ResultsOptions();
        this.setToLast();
    }

    public void saveToLast() {
        lastDataName = this.variableSelector.getSelectedData();
        lastRowModel = (DefaultListModel)this.rowList.getModel();
        lastColumnModel = (DefaultListModel)this.columnList.getModel();
        lastStratumModel = (DefaultListModel)this.stratumList.getModel();
        lastSubset = this.subsetPanel.getText();
        lastCellOpt = this.cellOpt;
        lastStatOpt = this.statOpt;
        lastResultOpt = this.resultOpt;
    }

    public void setToLast() {
        boolean bl = false;
        if (lastDataName == null || lastStratumModel == null || lastColumnModel == null || lastRowModel == null || lastStatOpt == null || lastResultOpt == null || lastCellOpt == null) {
            this.reset(true);
            return;
        }
        this.variableSelector.setSelectedData(lastDataName);
        bl = this.variableSelector.removeAll(lastRowModel);
        if (!bl) {
            this.reset(true);
            return;
        }
        this.rowList.setModel(lastRowModel);
        bl = this.variableSelector.removeAll(lastColumnModel);
        if (!bl) {
            this.reset(true);
            return;
        }
        this.columnList.setModel(lastColumnModel);
        bl = this.variableSelector.removeAll(lastStratumModel);
        if (!bl) {
            this.reset(true);
            return;
        }
        this.stratumList.setModel(lastStratumModel);
        this.addRemoveStratumButton.setList(this.stratumList);
        this.addRemoveStratumButton.refresh();
        if (RController.isValidSubsetExp((String)lastSubset, (String)lastDataName)) {
            this.subsetPanel.setText(lastSubset);
        }
        this.cellOpt = lastCellOpt;
        this.statOpt = lastStatOpt;
        this.resultOpt = lastResultOpt;
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.help = new HelpButton("pmwiki.php?n=Main.ContingencyTables");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(910, 71, 977, 15, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.help.addActionListener(this);
            this.postHoc = new JButton();
            this.getContentPane().add((Component)this.postHoc, new AnchorConstraint(217, 954, 269, 818, 1, 1, 1, 1));
            this.postHoc.setText("Post-Hoc");
            this.postHoc.setPreferredSize(new Dimension(100, 27));
            this.postHoc.addActionListener(this);
            this.statistics = new JButton();
            this.getContentPane().add((Component)this.statistics, new AnchorConstraint(142, 954, 194, 818, 1, 1, 1, 1));
            this.statistics.setText("Statistics");
            this.statistics.setPreferredSize(new Dimension(100, 27));
            this.statistics.addActionListener(this);
            this.cells = new JButton();
            this.getContentPane().add((Component)this.cells, new AnchorConstraint(62, 954, 118, 818, 1, 1, 1, 1));
            this.cells.setText("Cells");
            this.cells.setPreferredSize(new Dimension(100, 29));
            this.cells.addActionListener(this);
            this.addRow = new IconButton("/icons/1rightarrow_32.png", "Add Row", this, "Add Row");
            this.getContentPane().add((Component)this.addRow, new AnchorConstraint(76, 442, 153, 371, 1, 1, 0, 0));
            this.addRow.setPreferredSize(new Dimension(42, 42));
            this.addRow.setContentAreaFilled(false);
            this.okCancel = new OkayCancelPanel(true, true, this);
            this.getContentPane().add((Component)this.okCancel, new AnchorConstraint(950, 900, 977, 550, 0, 0, 1, 1));
            this.okCancel.setPreferredSize(new Dimension(300, 40));
            this.strataPanel = new JPanel();
            Serializable serializable = new BorderLayout();
            this.strataPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add((Component)this.strataPanel, new AnchorConstraint(650, 776, 749, 469, 1, 1, 1, 1));
            this.strataPanel.setPreferredSize(new Dimension(226, 50));
            this.strataPanel.setBorder(BorderFactory.createTitledBorder("Stratify By"));
            DefaultListModel defaultListModel = new DefaultListModel();
            this.stratumList = new SingletonDJList();
            this.strataPanel.add((Component)this.stratumList, "Center");
            this.stratumList.setModel(defaultListModel);
            this.columnPanel = new JPanel();
            serializable = new BorderLayout();
            this.columnPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add((Component)this.columnPanel, new AnchorConstraint(349, 776, 639, 469, 1, 1, 1, 1));
            this.columnPanel.setPreferredSize(new Dimension(226, 150));
            this.columnPanel.setEnabled(false);
            this.columnPanel.setBorder(BorderFactory.createTitledBorder("Column"));
            defaultListModel = new DefaultListModel();
            this.columnList = new DJList();
            this.columnList.setBorder(BorderFactory.createBevelBorder(1));
            this.columnPanel.add((Component)this.columnList, "Center");
            this.columnList.setModel(defaultListModel);
            this.rowPanel = new JPanel();
            serializable = new BorderLayout();
            this.rowPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add((Component)this.rowPanel, new AnchorConstraint(24, 777, 325, 469, 1, 1, 1, 1));
            this.rowPanel.setPreferredSize(new Dimension(227, 156));
            this.rowPanel.setBorder(BorderFactory.createTitledBorder("Row"));
            defaultListModel = new DefaultListModel();
            this.rowList = new DJList();
            this.rowList.setBorder(BorderFactory.createBevelBorder(1));
            this.rowPanel.add((Component)this.rowList, "Center");
            this.rowList.setModel(defaultListModel);
            this.variableSelector = new VariableSelector();
            this.getContentPane().add((Component)this.variableSelector, new AnchorConstraint(24, 355, 834, 18, 1, 1, 1, 1));
            this.variableSelector.setPreferredSize(new Dimension(248, 419));
            this.variableSelector.getJComboBox().addActionListener(this);
            this.removeRow = new IconButton("/icons/1leftarrow_32.png", "Remove Row", this, "Remove Row");
            this.getContentPane().add((Component)this.removeRow, new AnchorConstraint(169, 442, 153, 371, 1, 1, 0, 0));
            this.removeRow.setPreferredSize(new Dimension(42, 42));
            this.removeRow.setContentAreaFilled(false);
            this.addColumn = new IconButton("/icons/1rightarrow_32.png", "Add Column", this, "Add Column");
            this.getContentPane().add((Component)this.addColumn, new AnchorConstraint(405, 442, 153, 371, 1, 1, 0, 0));
            this.addColumn.setPreferredSize(new Dimension(42, 42));
            this.addColumn.setContentAreaFilled(false);
            this.removeColumn = new IconButton("/icons/1leftarrow_32.png", "Remove Column", this, "Remove Column");
            this.getContentPane().add((Component)this.removeColumn, new AnchorConstraint(498, 442, 153, 371, 1, 1, 0, 0));
            this.removeColumn.setPreferredSize(new Dimension(42, 42));
            this.removeColumn.setContentAreaFilled(false);
            this.addRemoveStratumButton = new SingletonAddRemoveButton(new String[]{"add", "remove"}, new String[]{"add", "remove"}, this.stratumList, this.variableSelector);
            this.getContentPane().add((Component)this.addRemoveStratumButton, new AnchorConstraint(674, 442, 153, 371, 1, 1, 0, 0));
            this.addRemoveStratumButton.setPreferredSize(new Dimension(42, 42));
            this.results = new JButton();
            this.getContentPane().add((Component)this.results, new AnchorConstraint(293, 954, 345, 818, 1, 1, 1, 1));
            this.results.setText("Results");
            this.results.setPreferredSize(new Dimension(100, 27));
            this.results.addActionListener(this);
            serializable = new JPanel();
            ((Container)serializable).setLayout(new BorderLayout());
            ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder("Subset"));
            this.subsetPanel = new SubsetPanel(this.variableSelector.getJComboBox());
            ((Container)serializable).add(this.subsetPanel);
            this.getContentPane().add((Component)serializable, new AnchorConstraint(750, 776, 893, 469, 1, 1, 1, 1));
            this.subsetPanel.setBorder(BorderFactory.createTitledBorder("Subset"));
            this.subsetPanel.setPreferredSize(new Dimension(226, 53));
            this.setTitle("Contingency Tables");
            this.setMinimumSize(new Dimension(700, 500));
            this.setSize(736, 539);
            this.postHoc.setVisible(false);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void reset(boolean bl) {
        this.rowList.setModel(new DefaultListModel());
        this.columnList.setModel(new DefaultListModel());
        this.stratumList.setModel(new DefaultListModel());
        this.addRemoveStratumButton.setList(this.stratumList);
        this.addRemoveStratumButton.refresh();
        this.subsetPanel.setText("");
        if (bl) {
            this.cellOpt = new CellOptions();
            this.statOpt = new StatisticsOptions();
            this.resultOpt = new ResultsOptions();
        }
        this.variableSelector.reset();
    }

    public boolean executeTables() {
        String string = this.variableSelector.getSelectedData();
        String string2 = this.resultOpt.name;
        boolean bl = false;
        if (string2 == "") {
            string2 = "tables";
            string2 = RController.makeValidVariableName((String)string2);
            string2 = Deducer.getUniqueName(string2);
        } else {
            string2 = Deducer.getUniqueName(string2);
        }
        if (this.subsetPanel.getText().length() > 0) {
            String string3 = this.subsetPanel.getText();
            if (SubsetDialog.isValidSubsetExp(string3, string)) {
                String string4 = Deducer.getUniqueName("tmp." + string);
                this.rCmd = this.rCmd + string4 + "<-subset(" + string + ", " + string3 + ")" + "\n";
                SubsetDialog.addToHistory(string, string3);
                string = string4;
                bl = true;
            } else {
                JOptionPane.showMessageDialog(this, "Invalid Subset. Please enter a logical expression");
                return false;
            }
        }
        if (this.rowList.getModel().getSize() == 0 || this.columnList.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(this, "Please select both column and row variables.");
            return false;
        }
        this.rCmd = this.rCmd + string2 + "<-contingency.tables(\n\trow.vars=" + Deducer.makeRCollection(this.rowList.getModel(), "d", false) + ",\n\tcol.vars=" + Deducer.makeRCollection(this.columnList.getModel(), "d", false) + (this.stratumList.getModel().getSize() > 0 ? ",\n\tstratum.var=" + ((DefaultListModel)this.stratumList.getModel()).get(0).toString() : "") + ",data=" + string + ")";
        this.rCmd = this.rCmd + this.statOpt.addStatistics(string2);
        this.rCmd = this.rCmd + "\n" + "print(" + string2 + (this.cellOpt.row ? ",prop.r=T" : ",prop.r=F") + (this.cellOpt.col ? ",prop.c=T" : ",prop.c=F") + (this.cellOpt.total ? ",prop.t=T" : ",prop.t=F") + (this.cellOpt.expected ? ",expected.n=T" : "") + (this.cellOpt.residuals ? ",residuals=T" : "") + (this.cellOpt.stdResiduals ? ",std.residuals=T" : "") + (this.cellOpt.adjResiduals ? ",adj.residuals=T" : "") + (this.cellOpt.noTables ? ",no.tables=T" : "") + ")";
        if (!this.resultOpt.keep) {
            this.rCmd = !bl ? this.rCmd + "\n" + "remove(" + string2 + ")" : this.rCmd + "\n" + "remove(" + string2 + "," + string + ")";
        }
        return true;
    }

    public void setDataName(String string, boolean bl) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "comboBoxChanged") {
            this.reset(false);
        }
        if (string == "Cancel") {
            this.dispose();
        } else if (string == "Run") {
            if (this.executeTables()) {
                Deducer.execute(this.rCmd);
                this.saveToLast();
                Deducer.setRecentData(this.variableSelector.getSelectedData());
                this.dispose();
            }
        } else if (string == "Reset") {
            this.reset(true);
        } else if (string == "Add Row") {
            Object[] objectArray = this.variableSelector.getJList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.remove(objectArray[i]);
                ((DefaultListModel)this.rowList.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Remove Row") {
            Object[] objectArray = this.rowList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.add(objectArray[i]);
                ((DefaultListModel)this.rowList.getModel()).removeElement(objectArray[i]);
            }
        } else if (string == "Add Column") {
            Object[] objectArray = this.variableSelector.getJList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.remove(objectArray[i]);
                ((DefaultListModel)this.columnList.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Remove Column") {
            Object[] objectArray = this.columnList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.add(objectArray[i]);
                ((DefaultListModel)this.columnList.getModel()).removeElement(objectArray[i]);
            }
        } else if (string == "Add Stratum") {
            Object[] objectArray = this.variableSelector.getJList().getSelectedValues();
            if (objectArray.length > 1) {
                this.variableSelector.getJList().setSelectedIndex(this.variableSelector.getJList().getSelectedIndex());
            } else if (objectArray.length == 1 && this.stratumList.getModel().getSize() == 0) {
                this.variableSelector.remove(objectArray[0]);
                ((DefaultListModel)this.stratumList.getModel()).addElement(objectArray[0]);
            }
        } else if (string == "Remove Stratum") {
            DefaultListModel defaultListModel = (DefaultListModel)this.stratumList.getModel();
            if (defaultListModel.getSize() > 0) {
                this.variableSelector.add(defaultListModel.remove(0));
            }
        } else if (string != "Post-Hoc") {
            if (string == "Statistics") {
                StatisticsDialog statisticsDialog = new StatisticsDialog(this, this.statOpt);
                statisticsDialog.setLocationRelativeTo(this);
                statisticsDialog.setVisible(true);
            } else if (string == "Cells") {
                CellDialog cellDialog = new CellDialog(this, this.cellOpt);
                cellDialog.setLocationRelativeTo(this);
                cellDialog.setVisible(true);
            } else if (string == "Results") {
                ResultsDialog resultsDialog = new ResultsDialog(this, this.resultOpt);
                resultsDialog.setLocationRelativeTo(this);
                resultsDialog.setVisible(true);
            }
        }
    }

    public class ResultsDialog
    extends JDialog
    implements ActionListener {
        private JCheckBox keep;
        private OkayCancelPanel okcan;
        private JTextField resultName;
        private JLabel name;

        public ResultsDialog(JDialog jDialog, ResultsOptions resultsOptions) {
            super(jDialog);
            this.initGUI();
            this.setOptions(resultsOptions);
        }

        public void setOptions(ResultsOptions resultsOptions) {
            if (resultsOptions.name == "") {
                this.resultName.setText("<auto>");
            } else {
                this.resultName.setText(resultsOptions.name);
            }
            this.keep.setSelected(resultsOptions.keep);
        }

        public ResultsOptions getOptions() {
            ResultsOptions resultsOptions = new ResultsOptions();
            resultsOptions.name = this.resultName.getText() != "<auto>" ? this.resultName.getText() : "";
            resultsOptions.keep = this.keep.isSelected();
            return resultsOptions;
        }

        private void initGUI() {
            try {
                this.getContentPane().setLayout(null);
                this.keep = new JCheckBox();
                this.getContentPane().add(this.keep);
                this.keep.setText("Keep results in workspace");
                this.keep.setBounds(49, 53, 216, 19);
                this.name = new JLabel();
                this.getContentPane().add(this.name);
                this.name.setText("Result name:");
                this.name.setBounds(54, 23, 86, 15);
                this.resultName = new JTextField();
                this.getContentPane().add(this.resultName);
                this.resultName.setText("<auto>");
                this.resultName.setBounds(140, 19, 98, 22);
                this.okcan = new OkayCancelPanel(false, false, this);
                this.getContentPane().add(this.okcan);
                this.okcan.setBounds(97, 95, 160, 40);
                this.setTitle("Result Options");
                this.setResizable(false);
                this.setSize(288, 165);
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == "Cancel") {
                this.dispose();
            } else if (string == "OK") {
                ContingencyDialog.this.resultOpt = this.getOptions();
                this.dispose();
            }
        }
    }

    public class StatisticsDialog
    extends JDialog
    implements ActionListener {
        private JPanel nomByNomPanel;
        private JCheckBox mantelHaen;
        private JButton custom;
        private JButton helpButton;
        private JButton kruskalOptions;
        private JButton exchAssump;
        private IconButton lrgAssump;
        private JCheckBox kruskal;
        private JPanel nomByOrdPanel;
        private JButton spearmanOptions;
        private IconButton lrgAssump1;
        private IconButton lrgAssump2;
        private JSeparator jSeparator4;
        private IconButton lrgAssump3;
        private IconButton lrgAssump9;
        private JCheckBox spearmans;
        private JButton kendallOptions;
        private IconButton lrgAssump4;
        private JCheckBox kendall;
        private JPanel ordByOrdPanel;
        private JButton homoAssump;
        private IconButton lrgAssump5;
        private JSeparator jSeparator3;
        private JSeparator jSeparator2;
        private JLabel strataLabel;
        private JSeparator jSeparator1;
        private JSeparator sep;
        private IconButton lrgAssump6;
        private IconButton lrgAssump7;
        private JButton liklihoodOptions;
        private JCheckBox liklihood;
        private JButton mantelOptions;
        private JButton fishersOptions;
        private JCheckBox fishers;
        private JButton chisqOptions;
        private JCheckBox chisq;
        private OkayCancelPanel okcan;
        private IconButton approxAssump;
        private ChiOptions chiSquared;
        private LikeOptions lrTest;

        public StatisticsDialog(JDialog jDialog, StatisticsOptions statisticsOptions) {
            super(jDialog);
            this.initGUI();
            this.setOptions(statisticsOptions);
            if (((ContingencyDialog)ContingencyDialog.this).statOpt.chiSquared.mc) {
                this.lrgAssump7.setVisible(false);
                this.approxAssump.setVisible(true);
            } else {
                this.lrgAssump7.setVisible(true);
                this.approxAssump.setVisible(false);
            }
        }

        public void setOptions(StatisticsOptions statisticsOptions) {
            this.mantelHaen.setSelected(statisticsOptions.mantelHaen);
            this.kruskal.setSelected(statisticsOptions.kruskal);
            this.spearmans.setSelected(statisticsOptions.spearmans);
            this.kendall.setSelected(statisticsOptions.kendall);
            this.liklihood.setSelected(statisticsOptions.liklihood);
            this.fishers.setSelected(statisticsOptions.fishers);
            this.chisq.setSelected(statisticsOptions.chisq);
            this.chiSquared = statisticsOptions.chiSquared;
            this.lrTest = statisticsOptions.lrTest;
        }

        public StatisticsOptions getOptions() {
            StatisticsOptions statisticsOptions = new StatisticsOptions();
            statisticsOptions.mantelHaen = this.mantelHaen.isSelected();
            statisticsOptions.kruskal = this.kruskal.isSelected();
            statisticsOptions.spearmans = this.spearmans.isSelected();
            statisticsOptions.kendall = this.kendall.isSelected();
            statisticsOptions.liklihood = this.liklihood.isSelected();
            statisticsOptions.fishers = this.fishers.isSelected();
            statisticsOptions.chisq = this.chisq.isSelected();
            statisticsOptions.chiSquared = this.chiSquared;
            statisticsOptions.lrTest = this.lrTest;
            return statisticsOptions;
        }

        private void initGUI() {
            try {
                this.getContentPane().setLayout(null);
                this.okcan = new OkayCancelPanel(false, false, this);
                this.getContentPane().add(this.okcan);
                this.okcan.setBounds(200, 280, 200, 40);
                this.nomByNomPanel = new JPanel();
                this.getContentPane().add(this.nomByNomPanel);
                this.nomByNomPanel.setLayout(null);
                this.nomByNomPanel.setBorder(BorderFactory.createTitledBorder("Nominal By Nominal"));
                this.nomByNomPanel.setBounds(12, 13, 192, 246);
                this.jSeparator3 = new JSeparator();
                this.nomByNomPanel.add(this.jSeparator3);
                this.jSeparator3.setBounds(105, 174, 83, 4);
                this.jSeparator2 = new JSeparator();
                this.nomByNomPanel.add(this.jSeparator2);
                this.jSeparator2.setPreferredSize(new Dimension(8, 4));
                this.jSeparator2.setBounds(5, 174, 8, 4);
                this.strataLabel = new JLabel();
                this.nomByNomPanel.add(this.strataLabel);
                this.strataLabel.setText("Cross-Stratum");
                this.strataLabel.setPreferredSize(new Dimension(95, 15));
                this.strataLabel.setHorizontalAlignment(0);
                this.strataLabel.setBounds(13, 169, 95, 15);
                this.sep = new JSeparator();
                this.nomByNomPanel.add(this.sep);
                this.sep.setPreferredSize(new Dimension(79, 8));
                this.sep.setBounds(75, 68, 79, 8);
                this.lrgAssump7 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
                this.nomByNomPanel.add(this.lrgAssump7);
                this.lrgAssump7.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.lrgAssump7.setBounds(32, 38, 27, 27);
                this.approxAssump = new AssumptionIcon("/icons/mcapprox_assump.png", "Monte Carlo Approximation", null, "Monte Carlo Approximation");
                this.nomByNomPanel.add(this.approxAssump);
                this.approxAssump.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.approxAssump.setBounds(32, 38, 27, 27);
                this.lrgAssump9 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
                this.nomByNomPanel.add(this.lrgAssump9);
                this.lrgAssump9.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.lrgAssump9.setBounds(32, 95, 27, 27);
                this.liklihood = new JCheckBox();
                this.nomByNomPanel.add(this.liklihood);
                this.liklihood.setText("Likelihood");
                this.liklihood.setBounds(17, 76, 109, 19);
                this.mantelHaen = new JCheckBox();
                this.nomByNomPanel.add(this.mantelHaen);
                this.mantelHaen.setText("Mantel Haenszel");
                this.mantelHaen.setBounds(17, 190, 172, 19);
                this.fishers = new JCheckBox();
                this.nomByNomPanel.add(this.fishers);
                this.fishers.setText("Fisher's Exact");
                this.fishers.setBounds(17, 131, 174, 19);
                this.chisqOptions = new IconButton("/icons/advanced_21.png", "Chi-Squared Options", this, "Chi-Squared Options");
                this.nomByNomPanel.add(this.chisqOptions);
                this.chisqOptions.setBounds(149, 27, 27, 27);
                this.chisq = new JCheckBox();
                this.nomByNomPanel.add(this.chisq);
                this.chisq.setText("Chi-Squared");
                this.chisq.setBounds(17, 19, 170, 19);
                this.fishersOptions = new JButton();
                this.nomByNomPanel.add(this.fishersOptions);
                this.fishersOptions.setBounds(149, 137, 27, 21);
                this.fishersOptions.addActionListener(this);
                this.mantelOptions = new JButton();
                this.nomByNomPanel.add(this.mantelOptions);
                this.mantelOptions.setBounds(149, 199, 27, 21);
                this.mantelOptions.addActionListener(this);
                this.liklihoodOptions = new IconButton("/icons/advanced_21.png", "Liklihood Ratio Options", this, "Liklihood Ratio Options");
                this.nomByNomPanel.add(this.liklihoodOptions);
                this.liklihoodOptions.setBounds(149, 82, 27, 27);
                this.lrgAssump6 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
                this.nomByNomPanel.add(this.lrgAssump6);
                this.lrgAssump6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.lrgAssump6.setBounds(32, 94, 27, 27);
                this.jSeparator1 = new JSeparator();
                this.nomByNomPanel.add(this.jSeparator1);
                this.jSeparator1.setPreferredSize(new Dimension(79, 3));
                this.jSeparator1.setBounds(75, 122, 79, 3);
                this.lrgAssump5 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
                this.nomByNomPanel.add(this.lrgAssump5);
                this.lrgAssump5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.lrgAssump5.setBounds(32, 215, 27, 27);
                this.homoAssump = new AssumptionIcon("/icons/homo_assump.png", "Homogeneity Across Strata", null, "Homogeneity Across Strata");
                this.nomByNomPanel.add(this.homoAssump);
                this.homoAssump.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.homoAssump.setBounds(63, 215, 27, 27);
                this.ordByOrdPanel = new JPanel();
                this.getContentPane().add(this.ordByOrdPanel);
                this.ordByOrdPanel.setLayout(null);
                this.ordByOrdPanel.setBounds(217, 12, 192, 136);
                this.ordByOrdPanel.setBorder(BorderFactory.createTitledBorder("Ordinal By Ordinal"));
                this.kendall = new JCheckBox();
                this.ordByOrdPanel.add(this.kendall);
                this.kendall.setText("Kendall's Tau");
                this.kendall.setBounds(17, 20, 130, 19);
                this.lrgAssump4 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
                this.ordByOrdPanel.add(this.lrgAssump4);
                this.lrgAssump4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.lrgAssump4.setBounds(33, 39, 27, 27);
                this.kendallOptions = new JButton();
                this.ordByOrdPanel.add(this.kendallOptions);
                this.kendallOptions.setText("Kendall Options");
                this.kendallOptions.setBounds(147, 27, 27, 21);
                this.kendallOptions.addActionListener(this);
                this.spearmans = new JCheckBox();
                this.ordByOrdPanel.add(this.spearmans);
                this.spearmans.setText("Spearman's Rho");
                this.spearmans.setBounds(17, 78, 131, 19);
                this.lrgAssump3 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
                this.ordByOrdPanel.add(this.lrgAssump3);
                this.lrgAssump3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.lrgAssump3.setBounds(33, 39, 27, 27);
                this.jSeparator4 = new JSeparator();
                this.ordByOrdPanel.add(this.jSeparator4);
                this.jSeparator4.setBounds(70, 70, 77, 7);
                this.lrgAssump2 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
                this.ordByOrdPanel.add(this.lrgAssump2);
                this.lrgAssump2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.lrgAssump2.setBounds(33, 39, 27, 27);
                this.lrgAssump1 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
                this.ordByOrdPanel.add(this.lrgAssump1);
                this.lrgAssump1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.lrgAssump1.setBounds(33, 103, 27, 27);
                this.spearmanOptions = new JButton();
                this.ordByOrdPanel.add(this.spearmanOptions);
                this.spearmanOptions.setBounds(148, 85, 27, 21);
                this.spearmanOptions.addActionListener(this);
                this.nomByOrdPanel = new JPanel();
                this.getContentPane().add(this.nomByOrdPanel);
                this.nomByOrdPanel.setBounds(217, 160, 190, 99);
                this.nomByOrdPanel.setBorder(BorderFactory.createTitledBorder("Nominal By Ordinal"));
                this.nomByOrdPanel.setLayout(null);
                this.kruskal = new JCheckBox();
                this.nomByOrdPanel.add(this.kruskal);
                this.kruskal.setText("Kruskal-Wallis");
                this.kruskal.setBounds(17, 20, 179, 19);
                this.lrgAssump = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
                this.nomByOrdPanel.add(this.lrgAssump);
                this.lrgAssump.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.lrgAssump.setBounds(32, 39, 27, 27);
                this.exchAssump = new AssumptionIcon("/icons/eqvar_assump.png", "Exchangability", null, "Exchangability");
                this.nomByOrdPanel.add(this.exchAssump);
                this.exchAssump.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.exchAssump.setBounds(63, 39, 27, 27);
                this.kruskalOptions = new JButton();
                this.nomByOrdPanel.add(this.kruskalOptions);
                this.kruskalOptions.setText("Kruskal-Wallis Options");
                this.kruskalOptions.setBounds(146, 32, 27, 21);
                this.kruskalOptions.addActionListener(this);
                this.helpButton = new JButton();
                this.getContentPane().add(this.helpButton);
                this.helpButton.setText("Help");
                this.helpButton.setBounds(12, 293, 41, 32);
                this.custom = new JButton();
                this.getContentPane().add(this.custom);
                this.custom.setText("Custom");
                this.custom.setBounds(171, 265, 82, 22);
                this.custom.addActionListener(this);
                this.setResizable(false);
                this.setSize(421, 361);
                this.setTitle("Table Statistics");
                this.chiSquared = new ChiOptions();
                this.lrTest = new LikeOptions();
                this.helpButton.setVisible(false);
                this.kruskalOptions.setVisible(false);
                this.spearmanOptions.setVisible(false);
                this.kendallOptions.setVisible(false);
                this.mantelOptions.setVisible(false);
                this.fishersOptions.setVisible(false);
                this.helpButton.setVisible(false);
                this.custom.setVisible(false);
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == "Cancel") {
                this.dispose();
            } else if (string == "OK") {
                ContingencyDialog.this.statOpt = this.getOptions();
                this.dispose();
            } else if (string == "Chi-Squared Options") {
                ChiOptionDialog chiOptionDialog = new ChiOptionDialog(this, this.chiSquared);
                chiOptionDialog.setLocationRelativeTo(this);
                chiOptionDialog.setVisible(true);
            } else if (string == "Liklihood Ratio Options") {
                LikeOptionDialog likeOptionDialog = new LikeOptionDialog(this, this.lrTest);
                likeOptionDialog.setLocationRelativeTo(this);
                likeOptionDialog.setVisible(true);
            }
        }

        public class LikeOptionDialog
        extends JDialog
        implements ActionListener {
            private JCheckBox conservative;
            OkayCancelPanel okcan;

            public LikeOptionDialog(JDialog jDialog, LikeOptions likeOptions) {
                super(jDialog);
                this.initGUI();
                this.setOptions(likeOptions);
            }

            public void setOptions(LikeOptions likeOptions) {
                this.conservative.setSelected(likeOptions.conservative);
            }

            public LikeOptions getOptions() {
                LikeOptions likeOptions = new LikeOptions();
                likeOptions.conservative = this.conservative.isSelected();
                return likeOptions;
            }

            private void initGUI() {
                try {
                    this.setLayout(null);
                    this.conservative = new JCheckBox();
                    this.getContentPane().add((Component)this.conservative, "Center");
                    this.conservative.setLayout(null);
                    this.conservative.setText("Conservative");
                    this.conservative.setBounds(100, 18, 145, 27);
                    this.okcan = new OkayCancelPanel(false, false, this);
                    this.getContentPane().add(this.okcan);
                    this.okcan.setBounds(80, 65, 170, 40);
                    this.setTitle("Liklihood Ratio Options");
                    this.setResizable(false);
                    this.setSize(305, 134);
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string == "OK") {
                    StatisticsDialog.this.lrTest = this.getOptions();
                    this.dispose();
                } else if (string == "Cancel") {
                    this.dispose();
                }
            }
        }

        public class ChiOptionDialog
        extends JDialog
        implements ActionListener {
            private JSeparator sep;
            private JSeparator jSeparator3;
            private JSeparator jSeparator2;
            private OkayCancelPanel okcan;
            private JLabel simSizeLabel;
            private JTextField simSize;
            private JSeparator jSeparator1;
            private JCheckBox monteCarlo;
            private JCheckBox asymptTest;
            private JCheckBox conservative;

            public ChiOptionDialog(JDialog jDialog, ChiOptions chiOptions) {
                super(jDialog);
                this.initGUI();
                this.setOptions(chiOptions);
            }

            public void setOptions(ChiOptions chiOptions) {
                this.monteCarlo.setSelected(chiOptions.mc);
                this.asymptTest.setSelected(chiOptions.asy);
                this.conservative.setSelected(chiOptions.conservative);
                this.simSize.setText(new Long(chiOptions.b).toString());
            }

            public ChiOptions getOptions() {
                long l;
                ChiOptions chiOptions = new ChiOptions();
                try {
                    l = Long.parseLong(this.simSize.getText());
                }
                catch (Exception exception) {
                    l = -1L;
                }
                chiOptions.b = l;
                chiOptions.mc = this.monteCarlo.isSelected();
                chiOptions.asy = this.asymptTest.isSelected();
                chiOptions.conservative = this.conservative.isSelected();
                return chiOptions;
            }

            private void initGUI() {
                try {
                    AnchorLayout anchorLayout = new AnchorLayout();
                    this.getContentPane().setLayout((LayoutManager)anchorLayout);
                    this.jSeparator3 = new JSeparator();
                    this.getContentPane().add((Component)this.jSeparator3, new AnchorConstraint(178, 237, 756, 205, 1, 1, 1, 1));
                    this.jSeparator3.setPreferredSize(new Dimension(10, 151));
                    this.jSeparator3.setOrientation(1);
                    this.okcan = new OkayCancelPanel(false, false, this);
                    this.getContentPane().add((Component)this.okcan, new AnchorConstraint(825, 944, 975, 444, 1, 1, 1, 1));
                    this.simSizeLabel = new JLabel();
                    this.getContentPane().add((Component)this.simSizeLabel, new AnchorConstraint(545, 583, 603, 309, 1, 1, 1, 1));
                    this.simSizeLabel.setText("Sample Size: ");
                    this.simSizeLabel.setPreferredSize(new Dimension(87, 15));
                    this.simSize = new JTextField();
                    this.getContentPane().add((Component)this.simSize, new AnchorConstraint(530, 825, 614, 602, 1, 1, 1, 1));
                    this.simSize.setText("5000");
                    this.simSize.setPreferredSize(new Dimension(71, 22));
                    this.monteCarlo = new JCheckBox();
                    this.getContentPane().add((Component)this.monteCarlo, new AnchorConstraint(434, 825, 507, 256, 1, 1, 1, 1));
                    this.monteCarlo.setText("Monte Carlo Simulation");
                    this.monteCarlo.setPreferredSize(new Dimension(181, 19));
                    this.monteCarlo.addActionListener(this);
                    this.asymptTest = new JCheckBox();
                    this.getContentPane().add((Component)this.asymptTest, new AnchorConstraint(239, 800, 312, 256, 1, 1, 1, 1));
                    this.asymptTest.setText("Asymptotic");
                    this.asymptTest.setPreferredSize(new Dimension(100, 19));
                    this.asymptTest.addActionListener(this);
                    this.conservative = new JCheckBox();
                    this.getContentPane().add((Component)this.conservative, new AnchorConstraint(82, 794, 155, 256, 1, 1, 1, 1));
                    this.conservative.setText("Conservative");
                    this.conservative.setPreferredSize(new Dimension(171, 19));
                    this.conservative.addActionListener(this);
                    this.conservative.setVisible(false);
                    this.sep = new JSeparator();
                    this.getContentPane().add((Component)this.sep, new AnchorConstraint(178, 825, 216, 205, 1, 1, 1, 1));
                    this.sep.setPreferredSize(new Dimension(197, 10));
                    this.jSeparator1 = new JSeparator();
                    this.getContentPane().add((Component)this.jSeparator1, new AnchorConstraint(381, 693, 411, 290, 1, 1, 1, 1));
                    this.jSeparator1.setPreferredSize(new Dimension(128, 8));
                    this.jSeparator2 = new JSeparator();
                    this.getContentPane().add((Component)this.jSeparator2, new AnchorConstraint(660, 693, 706, 290, 1, 1, 1, 1));
                    this.jSeparator2.setPreferredSize(new Dimension(128, 12));
                    this.setResizable(false);
                    this.setSize(318, 283);
                    this.setTitle("Chi Squared Test Options");
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string == "Cancel") {
                    this.dispose();
                } else if (string == "OK") {
                    ChiOptions chiOptions = this.getOptions();
                    if (chiOptions.b < 1L && this.monteCarlo.isSelected()) {
                        JOptionPane.showMessageDialog(this, "Please enter a valid monte carlo sample size");
                        this.simSize.setText("10000");
                        return;
                    }
                    if (!chiOptions.isValid()) {
                        JOptionPane.showMessageDialog(this, "Please select the type of test you wish to perform.\n\t(Asymptotic and/or Monte Carlo)");
                        return;
                    }
                    StatisticsDialog.this.chiSquared = chiOptions;
                    if (((StatisticsDialog)StatisticsDialog.this).chiSquared.mc) {
                        StatisticsDialog.this.lrgAssump7.setVisible(false);
                        StatisticsDialog.this.approxAssump.setVisible(true);
                    } else {
                        StatisticsDialog.this.lrgAssump7.setVisible(true);
                        StatisticsDialog.this.approxAssump.setVisible(false);
                    }
                    this.dispose();
                }
            }
        }
    }

    public class CellDialog
    extends JDialog
    implements ActionListener {
        private JPanel cellSumPanel;
        private JCheckBox rowPerc;
        private JCheckBox noTables;
        private OkayCancelPanel okcan;
        private JCheckBox adjResid;
        private JCheckBox stdResid;
        private JCheckBox resid;
        private JCheckBox expected;
        private JPanel chiSumPanel;
        private JCheckBox totalPerc;
        private JCheckBox colPerc;

        public CellDialog(JDialog jDialog, CellOptions cellOptions) {
            super(jDialog);
            this.initGUI();
            this.setOptions(cellOptions);
        }

        public void setOptions(CellOptions cellOptions) {
            this.rowPerc.setSelected(cellOptions.row);
            this.colPerc.setSelected(cellOptions.col);
            this.totalPerc.setSelected(cellOptions.total);
            this.expected.setSelected(cellOptions.expected);
            this.resid.setSelected(cellOptions.residuals);
            this.stdResid.setSelected(cellOptions.stdResiduals);
            this.adjResid.setSelected(cellOptions.adjResiduals);
            this.noTables.setSelected(cellOptions.noTables);
        }

        public CellOptions getOptions() {
            CellOptions cellOptions = new CellOptions();
            cellOptions.row = this.rowPerc.isSelected();
            cellOptions.col = this.colPerc.isSelected();
            cellOptions.total = this.totalPerc.isSelected();
            cellOptions.expected = this.expected.isSelected();
            cellOptions.residuals = this.resid.isSelected();
            cellOptions.stdResiduals = this.stdResid.isSelected();
            cellOptions.adjResiduals = this.adjResid.isSelected();
            cellOptions.noTables = this.noTables.isSelected();
            return cellOptions;
        }

        private void initGUI() {
            try {
                this.getContentPane().setLayout(null);
                this.cellSumPanel = new JPanel();
                this.getContentPane().add(this.cellSumPanel);
                this.cellSumPanel.setBounds(12, 17, 147, 133);
                this.cellSumPanel.setBorder(BorderFactory.createTitledBorder("Percentages"));
                this.cellSumPanel.setLayout(null);
                this.rowPerc = new JCheckBox();
                this.cellSumPanel.add(this.rowPerc);
                this.rowPerc.setText("Row");
                this.rowPerc.setBounds(17, 26, 125, 19);
                this.colPerc = new JCheckBox();
                this.cellSumPanel.add(this.colPerc);
                this.colPerc.setText("Column");
                this.colPerc.setBounds(17, 51, 125, 19);
                this.totalPerc = new JCheckBox();
                this.cellSumPanel.add(this.totalPerc);
                this.totalPerc.setText("Total");
                this.totalPerc.setBounds(17, 76, 125, 19);
                this.chiSumPanel = new JPanel();
                this.getContentPane().add(this.chiSumPanel);
                this.chiSumPanel.setBounds(180, 17, 208, 133);
                this.chiSumPanel.setBorder(BorderFactory.createTitledBorder("Chi-Squared"));
                this.chiSumPanel.setLayout(null);
                this.expected = new JCheckBox();
                this.chiSumPanel.add(this.expected);
                this.expected.setText("Expected");
                this.expected.setBounds(17, 26, 180, 19);
                this.resid = new JCheckBox();
                this.chiSumPanel.add(this.resid);
                this.resid.setText("Residuals");
                this.resid.setBounds(17, 51, 180, 19);
                this.stdResid = new JCheckBox();
                this.chiSumPanel.add(this.stdResid);
                this.stdResid.setText("Standardized Residuals");
                this.stdResid.setBounds(17, 72, 180, 19);
                this.adjResid = new JCheckBox();
                this.chiSumPanel.add(this.adjResid);
                this.adjResid.setText("Adjusted Residuals");
                this.adjResid.setBounds(17, 97, 180, 19);
                this.okcan = new OkayCancelPanel(false, false, this);
                this.getContentPane().add(this.okcan);
                this.okcan.setBounds(170, 150, 200, 50);
                this.noTables = new JCheckBox();
                this.getContentPane().add(this.noTables);
                this.noTables.setText("Don't print tables");
                this.noTables.setBounds(12, 162, 147, 19);
                this.setTitle("Table Cell Contents");
                this.setResizable(false);
                this.setSize(400, 225);
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == "OK") {
                ContingencyDialog.this.cellOpt = this.getOptions();
                this.dispose();
            } else if (string == "Cancel") {
                this.dispose();
            }
        }
    }

    public class ResultsOptions {
        public boolean keep = false;
        public String name = "";
    }

    public class StatisticsOptions {
        public boolean mantelHaen = false;
        public boolean kruskal = false;
        public boolean spearmans = false;
        public boolean kendall = false;
        public boolean liklihood = false;
        public boolean fishers = false;
        public boolean chisq = true;
        public ChiOptions chiSquared = new ChiOptions();
        public LikeOptions lrTest = new LikeOptions();

        public String addStatistics(String string) {
            String string2 = "";
            if (this.chisq) {
                string2 = string2 + "\n" + string + "<-add.chi.squared(" + string + (this.chiSquared.conservative ? ",conservative=T" : "") + (this.chiSquared.mc ? ",simulate.p.value=T,B=" + this.chiSquared.b : "") + ")";
            }
            if (this.liklihood) {
                string2 = string2 + "\n" + string + "<-add.likelihood.ratio(" + string + (this.lrTest.conservative ? ",conservative=T" : "") + ")";
            }
            if (this.fishers) {
                string2 = string2 + "\n" + string + "<-add.fishers.exact(" + string + ")";
            }
            if (this.spearmans) {
                string2 = string2 + "\n" + string + "<-add.correlation(" + string + ",method='spearman')";
            }
            if (this.kendall) {
                string2 = string2 + "\n" + string + "<-add.correlation(" + string + ",method='kendall')";
            }
            if (this.kruskal) {
                string2 = string2 + "\n" + string + "<-add.kruskal(" + string + ")";
            }
            if (this.mantelHaen) {
                string2 = string2 + "\n" + string + "<-add.mantel.haenszel(" + string + ")";
            }
            return string2;
        }
    }

    public class ChiOptions {
        public boolean asy = true;
        public boolean conservative = false;
        public boolean mc = false;
        public long b = 10000L;

        public ChiOptions() {
        }

        public ChiOptions(boolean bl, boolean bl2, boolean bl3, long l) {
            this.asy = bl;
            this.conservative = bl2;
            this.mc = bl3;
            this.b = l;
        }

        public boolean isValid() {
            return (this.b >= 1L || !this.mc) && (this.asy || this.mc);
        }

        public Object clone() {
            ChiOptions chiOptions = new ChiOptions();
            chiOptions.asy = this.asy;
            chiOptions.conservative = this.conservative;
            chiOptions.mc = this.mc;
            chiOptions.b = this.b;
            return chiOptions;
        }
    }

    public class LikeOptions {
        public boolean conservative = false;

        public LikeOptions() {
        }

        public LikeOptions(boolean bl) {
            this.conservative = bl;
        }
    }

    public class CellOptions {
        public boolean row = true;
        public boolean col = true;
        public boolean total = false;
        public boolean expected = false;
        public boolean residuals = false;
        public boolean stdResiduals = false;
        public boolean adjResiduals = false;
        public boolean noTables = false;
    }
}

