% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pulse.R
\name{plot_pulse}
\alias{plot_pulse}
\title{Visualise the instantaneous frequencies and amplitudes of a
decomposition}
\usage{
plot_pulse(
  pulse,
  style = "b",
  breaks = 500,
  bins = 100,
  cut = 18,
  lines = NULL,
  keep = NULL,
  lose = NULL
)
}
\arguments{
\item{pulse}{a pulse object (created by \code{\link{inst.pulse}} or
\code{\link{as.pulse}})}

\item{style}{whether to plot the distribution of frequency ('d'), the
spectral population ('p') or both ('b', is the default)}

\item{breaks, bins, cut}{parameter for the plots: \code{breaks} is fed to
\code{\link{plot_hist}}, \code{bins} is fed to \code{\link{plot_hex}}, and
\code{cut} defines the number of color cuts for \code{\link{plot_hex}}.
For better control use \code{\link{plot_hist}} and \code{\link{plot_hex}}
directly.}

\item{lines}{the period of lines to be added to the plots for better
visualisation}

\item{keep, lose}{which modes to plot or to not (keep overrides lose)}
}
\description{
Visualise the instantaneous frequencies and amplitudes of a
decomposition
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5) + t * 0.01

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)
dec <- extricate(xy, dt, nimf = 7, sifting = 10, repl = 10, comb = 10,
                 factor_noise = 10, speak = TRUE)

\dontrun{
plot_emd(dec, dir = tempdir())}


integrity(xy, dec)
parsimony(dec)

ht   <- inst.pulse(dec, plot = FALSE)

plot_pulse(ht, lines = c(30, 240))

}
