% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeclareDesign.R
\docType{package}
\name{DeclareDesign}
\alias{DeclareDesign-package}
\alias{DeclareDesign}
\title{DeclareDesign package}
\description{
The four main types of functions are to declare a step, to combine steps into designs,
and to manipulate designs and designers (functions that return designs).
}
\section{Design Steps}{

\describe{
  \item{\code{\link{declare_model}}}{Model step}
  \item{\code{\link{declare_inquiry}}}{Inquiry step}
  \item{\code{\link{declare_sampling}}}{Data strategy step (sampling)}
  \item{\code{\link{declare_assignment}}}{Data strategy step (assignment)}
  \item{\code{\link{declare_measurement}}}{Data strategy step (measurement)}
  \item{\code{\link{declare_estimator}}}{Answer strategy step (Estimator)}
  \item{\code{\link{declare_test}}}{Answer strategy step (Testing function)}
}
}

\section{Design Objects}{

\describe{
  \item{+}{Add steps to create a design}
  \item{\code{\link{redesign}}}{Change design parameters}
  \item{\code{\link{draw_data}}}{Draw a simulated dataset}
  \item{\code{\link{run_design}}}{Draw one set of inquiry values and estimates}
  \item{\code{\link{diagnose_design}}}{Diagnose a design}
  \item{\code{\link{cite_design}}}{Cite a design}
}
}

\section{Design Editing}{

\describe{
  \item{\code{\link{modify_design}}}{Add, delete or replace a step}
  \item{\code{\link{redesign}}}{Modify local variables within a design (advanced)}
}
}

\section{Designers}{

\describe{
  \item{\code{\link{expand_design}}}{Generate designs from a designer}
  \item{designs}{See also the \code{DesignLibrary} package for designers to use}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://declaredesign.org/r/declaredesign/}
  \item \url{https://github.com/DeclareDesign/DeclareDesign}
  \item Report bugs at \url{https://github.com/DeclareDesign/DeclareDesign/issues}
}

}
\author{
\strong{Maintainer}: Graeme Blair \email{graeme.blair@gmail.com} (\href{https://orcid.org/0000-0001-9164-2102}{ORCID})

Authors:
\itemize{
  \item Jasper Cooper \email{jaspercooper@gmail.com} (\href{https://orcid.org/0000-0002-8639-3188}{ORCID})
  \item Alexander Coppock \email{acoppock@gmail.com} (\href{https://orcid.org/0000-0002-5733-2386}{ORCID})
  \item Macartan Humphreys \email{macartan@gmail.com} (\href{https://orcid.org/0000-0001-7029-2326}{ORCID})
  \item Neal Fultz \email{nfultz@gmail.com}
}

}
