% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_functions.R
\name{draw_functions}
\alias{draw_functions}
\alias{draw_data}
\alias{draw_estimands}
\alias{draw_estimates}
\title{Draw data, estimates, and estimands from a design}
\usage{
draw_data(design, data = NULL, start = 1, end = length(design))

draw_estimands(...)

draw_estimates(...)
}
\arguments{
\item{design}{A design object, typically created using the + operator}

\item{data}{A data.frame object with sufficient information to get the data, estimates, estimands, an assignment vector, or a sample.}

\item{start}{(Defaults to 1) a scalar indicating which step in the design to begin with. By default all data steps are drawn, from step 1 to the last step of the design.}

\item{end}{(Defaults to \code{length(design)}) a scalar indicating which step in the design to finish drawing data by.}

\item{...}{A design or set of designs typically created using the + operator}
}
\description{
Draw data, estimates, and estimands from a design
}
\examples{

design <- declare_population(N = 100, u = rnorm(N)) +
  declare_potential_outcomes(Y ~ Z + u) +
  declare_estimand(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_sampling(n = 75) +
  declare_assignment(m = 50) +
  declare_reveal(Y, Z) +
  declare_estimator(Y ~ Z, estimand = "ATE")

dat <- draw_data(design)

dat_no_sampling <- draw_data(design, end = 3)

draw_estimands(design)

draw_estimates(design)

}
