/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.LinkedList;
import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.ColumnCall;
import net.starschema.clouddb.jdbc.list.FromExpression;
import net.starschema.clouddb.jdbc.list.FunctionCall;
import net.starschema.clouddb.jdbc.list.JokerCall;
import net.starschema.clouddb.jdbc.list.MultiCall;
import net.starschema.clouddb.jdbc.list.MultiCallResolver;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.Resolver;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.SubQuery;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import org.antlr.runtime.tree.Tree;

public class Expression
extends Node {
    TreeBuilder builder;
    SelectStatement selectStatement;
    FromExpression fromExpression;

    public LinkedList<Node> getChildren() {
        return this.children;
    }

    public SelectStatement getSelectStatement() {
        return this.selectStatement;
    }

    public Expression(List<ColumnCall> columns, TreeBuilder treeBuilder) {
        this.builder = treeBuilder;
        this.build(columns);
    }

    public void setSelectStatement(SelectStatement selectStatement) {
        this.selectStatement = selectStatement;
        this.fromExpression = selectStatement.getFromExpression();
    }

    public Expression(Tree t, TreeBuilder treeBuilder, FromExpression fromExpression, SelectStatement selectStatement) throws TreeParsingException {
        this.builder = treeBuilder;
        this.selectStatement = selectStatement;
        this.fromExpression = fromExpression;
        this.build(t);
    }

    public void addColumnCall(ColumnCall columnCall) {
        columnCall.setParentNode(this);
        this.children.addLast(columnCall);
    }

    public void build(List<ColumnCall> columns) {
        this.tokenType = 46;
        this.tokenName = JdbcGrammarParser.tokenNames[this.tokenType];
        this.logger.debug("Adding columns " + this.tokenName);
        for (int i = 0; i < columns.size(); ++i) {
            ColumnCall columnCall = columns.get(i);
            columnCall.setParentNode(this);
            this.children.addLast(columnCall);
        }
    }

    public void build(Tree t) throws TreeParsingException {
        if (t.getType() == 46) {
            this.tokenType = t.getType();
            this.tokenName = JdbcGrammarParser.tokenNames[this.tokenType];
            this.logger.debug("BUILDING " + this.tokenName);
            block6: for (int i = 0; i < t.getChildCount(); ++i) {
                Tree child = t.getChild(i);
                switch (child.getType()) {
                    case 19: {
                        ColumnCall columnCall2 = new ColumnCall(child, this.builder, this.fromExpression, this);
                        this.children.addLast(columnCall2);
                        continue block6;
                    }
                    case 53: {
                        FunctionCall functionCall = new FunctionCall(child, this.builder, this.selectStatement);
                        functionCall.setParentNode(this);
                        this.children.addLast(functionCall);
                        continue block6;
                    }
                    case 75: {
                        Resolver resolver = new Resolver(this.builder);
                        List<ColumnCall> parseSubQueryForJokerCalls = resolver.parseSubQForJokers((SubQuery)this.selectStatement.getFromExpression().children.get(0));
                        for (int j = 0; j < parseSubQueryForJokerCalls.size(); ++j) {
                            ColumnCall columnCall = parseSubQueryForJokerCalls.get(j);
                            columnCall.setParentNode(this);
                            this.children.addLast(columnCall);
                        }
                        continue block6;
                    }
                    case 92: {
                        MultiCallResolver multiCallResolver = new MultiCallResolver(new MultiCall(child, this.builder, this.fromExpression), this.fromExpression, this.builder);
                        List<ColumnCall> substitutesforJokerCalls1 = multiCallResolver.getSubstitutesforJokerCall();
                        for (ColumnCall columnCall : substitutesforJokerCalls1) {
                            columnCall.setParentNode(this);
                            this.children.addLast(columnCall);
                        }
                        continue block6;
                    }
                }
            }
        } else {
            throw new TreeParsingException("This Tree is not an EXPRESSION");
        }
    }

    public void deleteAllChildren() {
        this.children = new LinkedList();
    }

    public List<ColumnCall> getColumns() {
        this.logger.debug("CALLED GETCOLUMNS");
        return this.getAllinstancesof(ColumnCall.class, 19);
    }

    public List<FunctionCall> getFunctionCalls() {
        this.logger.debug("CALLED GETFUNCTIONCALLS");
        return this.getAllinstancesof(FunctionCall.class, 53);
    }

    public JokerCall getJokerCall() {
        for (Node node : this.children) {
            if (node.tokenType != 75) continue;
            return (JokerCall)node;
        }
        return null;
    }

    public List<MultiCall> getMultiCalls() {
        return this.getAllinstancesof(MultiCall.class, 92);
    }

    @Override
    public String toPrettyString() {
        return this.toPrettyString(-1);
    }

    @Override
    public String toPrettyString(int level) {
        String result = "";
        for (Node node : this.children) {
            result = result + node.toPrettyString() + ",";
        }
        String newLine = System.getProperty("line.separator");
        if (result.length() == 0) {
            return "";
        }
        return result.substring(0, result.length() - 1).replace(",", "," + newLine + this.tab(level)) + newLine;
    }
}

