/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.cmdlineverification;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.starschema.clouddb.jdbc.Logger;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BQXMLCredentialStore
implements CredentialStore {
    static Logger logger = Logger.getLogger(BQXMLCredentialStore.class.getName());
    String documentpath = null;

    public static byte[] decrypt(String clientSecret, byte[] argument) {
        byte[] ciphertext = argument;
        byte[] key = null;
        try {
            key = clientSecret.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        key = sha.digest(key);
        key = Arrays.copyOf(key, 16);
        SecretKeySpec secret = new SecretKeySpec(key, "AES");
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (NoSuchPaddingException e) {
            return null;
        }
        try {
            cipher.init(2, secret);
        }
        catch (InvalidKeyException e) {
            return null;
        }
        try {
            ciphertext = cipher.doFinal(ciphertext);
        }
        catch (IllegalBlockSizeException e) {
            return null;
        }
        catch (BadPaddingException e) {
            return null;
        }
        return ciphertext;
    }

    public static byte[] encrypt(String clientSecret, String argument) {
        byte[] key = null;
        try {
            key = clientSecret.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        key = sha.digest(key);
        key = Arrays.copyOf(key, 16);
        SecretKeySpec secret = new SecretKeySpec(key, "AES");
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (NoSuchPaddingException e) {
            return null;
        }
        try {
            cipher.init(1, secret);
        }
        catch (InvalidKeyException e) {
            return null;
        }
        try {
            return cipher.doFinal(argument.getBytes("UTF-8"));
        }
        catch (IllegalBlockSizeException e) {
            return null;
        }
        catch (BadPaddingException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String MD5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public BQXMLCredentialStore(String path) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(System.getProperty("user.home") + File.separator + ".bqjdbc" + File.separator + "xmllocation.properties"));
        }
        catch (IOException e) {
            logger.debug("Property file not found for credential store location setting default location for credentials");
            this.documentpath = System.getProperty("user.home") + File.separator + ".bqjdbc" + File.separator + "credentials.xml";
        }
        String Check = properties.getProperty("xmlpath");
        if (Check == null) {
            logger.debug("The property xmlpath is not found in the properties file, setting default location");
            this.documentpath = System.getProperty("user.home") + File.separator + ".bqjdbc" + File.separator + "credentials.xml";
        } else {
            logger.debug(properties.getProperty("xmlpath"));
            this.documentpath = properties.getProperty("xmlpath").contains("${user.home}") ? System.getProperty("user.home") + properties.getProperty("xmlpath").substring(properties.getProperty("xmlpath").lastIndexOf("}") + 1) : properties.getProperty("xmlpath");
            logger.info("Document path for the credentials is: " + this.documentpath);
        }
        File pathofdocumentpath = new File(new File(this.documentpath).getParent());
        if (!pathofdocumentpath.exists()) {
            pathofdocumentpath.mkdirs();
        }
    }

    @Override
    public void delete(String userId, Credential credential) throws IOException {
        Document doc = null;
        doc = this.loadDocument(this.documentpath);
        if (doc != null) {
            NodeList elements = doc.getElementsByTagName("Credential");
            Node loadelement = null;
            for (int i = 0; i < elements.getLength(); ++i) {
                Node mynode = elements.item(i).getAttributes().getNamedItem("ID");
                if (mynode == null || !mynode.getNodeValue().equals(BQXMLCredentialStore.MD5(userId))) continue;
                loadelement = (Element)elements.item(i);
            }
            if (loadelement != null) {
                loadelement.getParentNode().removeChild(loadelement);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            try {
                transformer = transformerFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new IOException(e);
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(this.documentpath));
            try {
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public boolean load(String userId, Credential credential) throws IOException {
        Document doc = null;
        doc = this.loadOrCreateDocument(this.documentpath);
        String ClientSecret = userId.substring(userId.indexOf(":") + 1);
        NodeList elements = doc.getElementsByTagName("Credential");
        Element loadelement = null;
        String EncodedRefreshToken = null;
        for (int i = 0; i < elements.getLength(); ++i) {
            Node mynode = elements.item(i).getAttributes().getNamedItem("ID");
            if (mynode == null || !mynode.getNodeValue().equals(BQXMLCredentialStore.MD5(userId))) continue;
            loadelement = (Element)elements.item(i);
            EncodedRefreshToken = loadelement.getAttribute("Token");
        }
        if (loadelement == null) {
            return false;
        }
        byte[] EncodedRefreshTokenBytes = EncodedRefreshToken.getBytes("UTF-8");
        byte[] Base64DecodedTokenBytes = Base64.decodeBase64(EncodedRefreshTokenBytes);
        byte[] decryptedRefreshTokenBytes = BQXMLCredentialStore.decrypt(ClientSecret, Base64DecodedTokenBytes);
        if (decryptedRefreshTokenBytes == null) {
            throw new IOException("Failed to decode RefreshToken");
        }
        credential.setExpiresInSeconds(null);
        credential.setExpirationTimeMilliseconds(null);
        credential.setRefreshToken(new String(decryptedRefreshTokenBytes, "UTF-8"));
        credential.setAccessToken(null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadDocument(String path) {
        FileInputStream file = null;
        try {
            file = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            Document doc;
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document document = doc = docBuilder.parse(file);
            return document;
        }
        catch (ParserConfigurationException e1) {
            Document document = null;
            return document;
        }
        catch (SAXException e) {
            Document document = null;
            return document;
        }
        catch (IOException e) {
            Document document = null;
            return document;
        }
        finally {
            try {
                ((InputStream)file).close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the credential store xml file.");
                return null;
            }
        }
    }

    private Document loadOrCreateDocument(String path) throws IOException {
        Document doc = null;
        doc = this.loadDocument(path);
        if (doc == null) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = docFactory.newDocumentBuilder();
                doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("ClientCredentials");
                doc.appendChild(rootElement);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = null;
                transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(path));
                transformer.transform(source, result);
            }
            catch (ParserConfigurationException e1) {
                logger.warn("", e1);
                throw new IOException("Failed to load", e1);
            }
            catch (TransformerConfigurationException e) {
                logger.warn("", e);
                throw new IOException("Failed to load", e);
            }
            catch (TransformerException e) {
                logger.warn("", e);
                throw new IOException("Failed to load", e);
            }
        }
        return doc;
    }

    @Override
    public void store(String userId, Credential credential) throws IOException {
        Document doc = null;
        logger.debug(this.documentpath);
        doc = this.loadOrCreateDocument(this.documentpath);
        NodeList elements = doc.getElementsByTagName("Credential");
        Element loadelement = null;
        for (int i = 0; i < elements.getLength(); ++i) {
            Node mynode = elements.item(i).getAttributes().getNamedItem("ID");
            if (mynode == null || !mynode.getNodeValue().equals(BQXMLCredentialStore.MD5(userId))) continue;
            loadelement = (Element)elements.item(i);
        }
        if (loadelement != null) {
            String ClientSecret = userId.substring(userId.indexOf(":") + 1);
            byte[] RefreshTokenBytes = BQXMLCredentialStore.encrypt(ClientSecret, credential.getRefreshToken());
            if (RefreshTokenBytes == null) {
                throw new IOException("Failed to encrypt RefreshToken");
            }
            byte[] base64encodedtoken = Base64.encodeBase64(RefreshTokenBytes);
            String encryptedRefreshToken = new String(base64encodedtoken, "UTF-8");
            loadelement.setAttribute("Token", encryptedRefreshToken);
        } else {
            Element rootElement = (Element)doc.getElementsByTagName("ClientCredentials").item(0);
            Element ClientCredential = doc.createElement("Credential");
            String ClientSecret = userId.substring(userId.indexOf(":") + 1);
            try {
                ClientCredential.setAttribute("ID", BQXMLCredentialStore.MD5(userId));
            }
            catch (DOMException e) {
                throw new IOException(e);
            }
            byte[] RefreshTokenBytes = BQXMLCredentialStore.encrypt(ClientSecret, credential.getRefreshToken());
            if (RefreshTokenBytes == null) {
                throw new IOException("Failed to encrypt RefreshToken");
            }
            byte[] base64encodedtoken = Base64.encodeBase64(RefreshTokenBytes);
            String encryptedRefreshToken = new String(base64encodedtoken, "UTF-8");
            ClientCredential.setAttribute("Token", encryptedRefreshToken);
            rootElement.appendChild(ClientCredential);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(this.documentpath));
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }
}

