/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ApplicationIntent;
import com.microsoft.sqlserver.jdbc.AuthenticationScheme;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriverBooleanProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverIntProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverPropertyInfo;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerDriver
implements Driver {
    static final String PRODUCT_NAME = "Microsoft JDBC Driver 4.0 for SQL Server";
    static final String DEFAULT_APP_NAME = "Microsoft JDBC Driver for SQL Server";
    private static final String[] TRUE_FALSE = new String[]{"true", "false"};
    private static final SQLServerDriverPropertyInfo[] DRIVER_PROPERTIES = new SQLServerDriverPropertyInfo[]{new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.APPLICATION_INTENT.toString(), SQLServerDriverStringProperty.APPLICATION_INTENT.getDefaultValue(), false, new String[]{ApplicationIntent.READ_ONLY.toString(), ApplicationIntent.READ_WRITE.toString()}), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.APPLICATION_NAME.toString(), SQLServerDriverStringProperty.APPLICATION_NAME.getDefaultValue(), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.DATABASE_NAME.toString(), SQLServerDriverStringProperty.DATABASE_NAME.getDefaultValue(), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverBooleanProperty.DISABLE_STATEMENT_POOLING.toString(), Boolean.toString(SQLServerDriverBooleanProperty.DISABLE_STATEMENT_POOLING.getDefaultValue()), false, new String[]{"true"}), new SQLServerDriverPropertyInfo(SQLServerDriverBooleanProperty.ENCRYPT.toString(), Boolean.toString(SQLServerDriverBooleanProperty.ENCRYPT.getDefaultValue()), false, TRUE_FALSE), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.FAILOVER_PARTNER.toString(), SQLServerDriverStringProperty.FAILOVER_PARTNER.getDefaultValue(), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.HOSTNAME_IN_CERTIFICATE.toString(), SQLServerDriverStringProperty.HOSTNAME_IN_CERTIFICATE.getDefaultValue(), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.INSTANCE_NAME.toString(), SQLServerDriverStringProperty.INSTANCE_NAME.getDefaultValue(), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverBooleanProperty.INTEGRATED_SECURITY.toString(), Boolean.toString(SQLServerDriverBooleanProperty.INTEGRATED_SECURITY.getDefaultValue()), false, TRUE_FALSE), new SQLServerDriverPropertyInfo(SQLServerDriverBooleanProperty.LAST_UPDATE_COUNT.toString(), Boolean.toString(SQLServerDriverBooleanProperty.LAST_UPDATE_COUNT.getDefaultValue()), false, TRUE_FALSE), new SQLServerDriverPropertyInfo(SQLServerDriverIntProperty.LOCK_TIMEOUT.toString(), Integer.toString(SQLServerDriverIntProperty.LOCK_TIMEOUT.getDefaultValue()), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverIntProperty.LOGIN_TIMEOUT.toString(), Integer.toString(SQLServerDriverIntProperty.LOGIN_TIMEOUT.getDefaultValue()), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverBooleanProperty.MULTI_SUBNET_FAILOVER.toString(), Boolean.toString(SQLServerDriverBooleanProperty.MULTI_SUBNET_FAILOVER.getDefaultValue()), false, TRUE_FALSE), new SQLServerDriverPropertyInfo(SQLServerDriverIntProperty.PACKET_SIZE.toString(), Integer.toString(SQLServerDriverIntProperty.PACKET_SIZE.getDefaultValue()), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.PASSWORD.toString(), SQLServerDriverStringProperty.PASSWORD.getDefaultValue(), true, null), new SQLServerDriverPropertyInfo(SQLServerDriverIntProperty.PORT_NUMBER.toString(), Integer.toString(SQLServerDriverIntProperty.PORT_NUMBER.getDefaultValue()), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.RESPONSE_BUFFERING.toString(), SQLServerDriverStringProperty.RESPONSE_BUFFERING.getDefaultValue(), false, new String[]{"adaptive", "full"}), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.SELECT_METHOD.toString(), SQLServerDriverStringProperty.SELECT_METHOD.getDefaultValue(), false, new String[]{"direct", "cursor"}), new SQLServerDriverPropertyInfo(SQLServerDriverBooleanProperty.SEND_STRING_PARAMETERS_AS_UNICODE.toString(), Boolean.toString(SQLServerDriverBooleanProperty.SEND_STRING_PARAMETERS_AS_UNICODE.getDefaultValue()), false, TRUE_FALSE), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.SERVER_NAME.toString(), SQLServerDriverStringProperty.SERVER_NAME.getDefaultValue(), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverBooleanProperty.TRUST_SERVER_CERTIFICATE.toString(), Boolean.toString(SQLServerDriverBooleanProperty.TRUST_SERVER_CERTIFICATE.getDefaultValue()), false, TRUE_FALSE), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.TRUST_STORE.toString(), SQLServerDriverStringProperty.TRUST_STORE.getDefaultValue(), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.TRUST_STORE_PASSWORD.toString(), SQLServerDriverStringProperty.TRUST_STORE_PASSWORD.getDefaultValue(), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverBooleanProperty.SEND_TIME_AS_DATETIME.toString(), Boolean.toString(SQLServerDriverBooleanProperty.SEND_TIME_AS_DATETIME.getDefaultValue()), false, TRUE_FALSE), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.USER.toString(), SQLServerDriverStringProperty.USER.getDefaultValue(), true, null), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.WORKSTATION_ID.toString(), SQLServerDriverStringProperty.WORKSTATION_ID.getDefaultValue(), false, null), new SQLServerDriverPropertyInfo(SQLServerDriverBooleanProperty.XOPEN_STATES.toString(), Boolean.toString(SQLServerDriverBooleanProperty.XOPEN_STATES.getDefaultValue()), false, TRUE_FALSE), new SQLServerDriverPropertyInfo(SQLServerDriverStringProperty.AUTHENTICATION_SCHEME.toString(), SQLServerDriverStringProperty.AUTHENTICATION_SCHEME.getDefaultValue(), false, new String[]{AuthenticationScheme.javaKerberos.toString(), AuthenticationScheme.nativeAuthentication.toString()})};
    private static final String[][] driverPropertiesSynonyms = new String[][]{{"database", SQLServerDriverStringProperty.DATABASE_NAME.toString()}, {"userName", SQLServerDriverStringProperty.USER.toString()}, {"server", SQLServerDriverStringProperty.SERVER_NAME.toString()}, {"port", SQLServerDriverIntProperty.PORT_NUMBER.toString()}};
    private static int baseID = 0;
    private final int instanceID = SQLServerDriver.nextInstanceID();
    private final String traceID = "SQLServerDriver:" + this.instanceID;
    private static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.Driver");
    private final String loggingClassName = "com.microsoft.sqlserver.jdbc.SQLServerDriver:" + this.instanceID;
    private static final Logger drLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerDriver");

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    public final String toString() {
        return this.traceID;
    }

    String getClassNameLogging() {
        return this.loggingClassName;
    }

    static Properties fixupProperties(Properties properties) throws SQLServerException {
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = SQLServerDriver.getNormalizedPropertyName(string, drLogger);
            if (null == string2) continue;
            String string3 = properties.getProperty(string);
            if (null != string3) {
                properties2.setProperty(string2, string3);
                continue;
            }
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidpropertyValue"));
            Object[] objectArray = new Object[]{string};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return properties2;
    }

    static Properties mergeURLAndSuppliedProperties(Properties properties, Properties properties2) throws SQLServerException {
        if (null == properties2) {
            return properties;
        }
        if (properties2.isEmpty()) {
            return properties;
        }
        Properties properties3 = SQLServerDriver.fixupProperties(properties2);
        for (int i = 0; i < DRIVER_PROPERTIES.length; ++i) {
            String string = DRIVER_PROPERTIES[i].getName();
            String string2 = properties3.getProperty(string);
            if (null == string2) continue;
            properties.put(string, string2);
        }
        return properties;
    }

    static String getNormalizedPropertyName(String string, Logger logger) {
        int n;
        if (null == string) {
            return string;
        }
        for (n = 0; n < driverPropertiesSynonyms.length; ++n) {
            if (!driverPropertiesSynonyms[n][0].equalsIgnoreCase(string)) continue;
            return driverPropertiesSynonyms[n][1];
        }
        for (n = 0; n < DRIVER_PROPERTIES.length; ++n) {
            if (!DRIVER_PROPERTIES[n].getName().equalsIgnoreCase(string)) continue;
            return DRIVER_PROPERTIES[n].getName();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Unknown property" + string);
        }
        return null;
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "connect", "Arguments not traced.");
        SQLServerConnection sQLServerConnection = null;
        Properties properties2 = this.parseAndMergeProperties(string, properties);
        if (properties2 != null) {
            sQLServerConnection = new SQLServerConnection(this.toString());
            sQLServerConnection.connect(properties2, null);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "connect", sQLServerConnection);
        return sQLServerConnection;
    }

    private final Properties parseAndMergeProperties(String string, Properties properties) throws SQLServerException {
        if (string == null) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_nullConnection"), null, 0, false);
        }
        Properties properties2 = Util.parseUrl(string, drLogger);
        if (properties2 == null) {
            return null;
        }
        int n = DriverManager.getLoginTimeout();
        if (n > 0) {
            properties2.put(SQLServerDriverIntProperty.LOGIN_TIMEOUT.toString(), new Integer(n).toString());
        }
        properties2 = SQLServerDriver.mergeURLAndSuppliedProperties(properties2, properties);
        return properties2;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "acceptsURL", "Arguments not traced.");
        boolean bl = false;
        try {
            bl = Util.parseUrl(string, drLogger) != null;
        }
        catch (SQLServerException sQLServerException) {
            bl = false;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "acceptsURL", bl);
        return bl;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getPropertyInfo", "Arguments not traced.");
        Properties properties2 = this.parseAndMergeProperties(string, properties);
        if (null == properties2) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_invalidConnection"), null, 0, false);
        }
        DriverPropertyInfo[] driverPropertyInfoArray = SQLServerDriver.getPropertyInfoFromProperties(properties2);
        loggerExternal.exiting(this.getClassNameLogging(), "getPropertyInfo");
        return driverPropertyInfoArray;
    }

    static final DriverPropertyInfo[] getPropertyInfoFromProperties(Properties properties) {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[DRIVER_PROPERTIES.length];
        for (int i = 0; i < DRIVER_PROPERTIES.length; ++i) {
            driverPropertyInfoArray[i] = DRIVER_PROPERTIES[i].build(properties);
        }
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        loggerExternal.entering(this.getClassNameLogging(), "getMajorVersion");
        loggerExternal.exiting(this.getClassNameLogging(), "getMajorVersion", new Integer(4));
        return 4;
    }

    @Override
    public int getMinorVersion() {
        loggerExternal.entering(this.getClassNameLogging(), "getMinorVersion");
        loggerExternal.exiting(this.getClassNameLogging(), "getMinorVersion", new Integer(0));
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        loggerExternal.entering(this.getClassNameLogging(), "jdbcCompliant");
        loggerExternal.exiting(this.getClassNameLogging(), "jdbcCompliant", true);
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new SQLServerDriver());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

