% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbWriteTable,DatabaseConnectorConnection,character,data.frame-method}
\alias{dbWriteTable,DatabaseConnectorConnection,character,data.frame-method}
\title{Copy data frames to database tables}
\usage{
\S4method{dbWriteTable}{DatabaseConnectorConnection,character,data.frame}(
  conn,
  name,
  value,
  overwrite = FALSE,
  append = FALSE,
  temporary = FALSE,
  oracleTempSchema = NULL,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  ...
)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{A character string specifying the unquoted DBMS table name,
or the result of a call to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{value}{a \link{data.frame} (or coercible to data.frame).}

\item{overwrite}{Overwrite an existing table (if exists)?}

\item{append}{Append to existing table?}

\item{temporary}{Should the table created as a temp table?}

\item{oracleTempSchema}{DEPRECATED: use \code{tempEmulationSchema} instead.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support temp tables. To
emulate temp tables, provide a schema with write privileges where temp tables
can be created.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbWriteTable()} returns \code{TRUE}, invisibly.
If the table exists, and both \code{append} and \code{overwrite} arguments are unset,
or \code{append = TRUE} and the data frame with the new data has different
column names,
an error is raised; the remote table remains unchanged.

An error is raised when calling this method for a closed
or invalid connection.
An error is also raised
if \code{name} cannot be processed with \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}
or if this results in a non-scalar.
Invalid values for the additional arguments \code{row.names},
\code{overwrite}, \code{append}, \code{field.types}, and \code{temporary}
(non-scalars,
unsupported data types,
\code{NA},
incompatible values,
duplicate
or missing names,
incompatible columns)
also raise an error.
}
\description{
Writes, overwrites or appends a data frame to a database table, optionally
converting row names to a column and specifying SQL data types for fields.
New code should prefer \code{\link[DBI:dbCreateTable]{dbCreateTable()}} and \code{\link[DBI:dbAppendTable]{dbAppendTable()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbWriteTable")}
}
\seealso{
Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendStatement}()}
}
