% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSpaceConnection.R
\docType{class}
\name{DataSpaceConnection}
\alias{DataSpaceConnection}
\title{The DataSpaceConnection class}
\usage{
DataSpaceConnection
}
\value{
an instance of \code{DataSpaceConnection}
}
\description{
The DataSpaceConnection class
}
\section{Constructor}{

\code{\link{connectDS}}
}

\section{Fields}{

\describe{
  \item{\code{config}}{
    A list. Stores configuration of the connection object such as
    URL, path and username.
  }
  \item{\code{availableStudies}}{
    A data.table. The table of available studies.
  }
  \item{\code{availableGroups}}{
    A data.table. The table of available groups.
  }
  \item{\code{mabGrid}}{
    A data.table. The filtered mAb grid.
  }
  \item{\code{mabGridSummary}}{
    A data.table. The filtered grid with updated \code{n_} columns and
    \code{geometric_mean_curve_ic50}.
  }
}
}

\section{Methods}{

\describe{
  \item{\code{initialize(login = NULL, password = NULL, verbose = FALSE,
  onStaging = FALSE)}}{
    Initialize a \code{DataSpaceConnection} object.
    See \code{\link{connectDS}}.
  }
  \item{\code{print()}}{
    Print the \code{DataSpaceConnection} object.
  }
  \item{\code{getStudy(study, groupId = NULL)}}{
    Create a \code{\link{DataSpaceStudy}} object.

    \code{study}: A character. Name of the study to retrieve.
  }
  \item{\code{getGroup(groupId)}}{
    Create a \code{\link{DataSpaceStudy}} object.

    \code{groupId}: An integer. ID of the group to retrieve.
  }
  \item{\code{refresh()}}{
    Refresh the connection object to update available studies and groups.
  }
  \item{\code{filterMabGrid(using, value)}}{
    Filter rows in the mAb grid by specifying the values to keep in the
    columns found in the \code{mabGrid} field. It takes the column and the
    values and filters the underlying tables.

    \code{using}: A character. Name of the column to filter.

    \code{value}: A character vector. Values to keep in the mAb grid.
  }
  \item{\code{getMab()}}{
    Create a \code{\link{DataSpaceMab}} object.
  }
  \item{\code{resetMabGrid()}}{
    Reset the mAb grid to the unfiltered state.
  }
}
}

\examples{
\dontrun{
# Create a connection (Initiate a DataSpaceConnection object)
con <- connectDS()
con

# Connect to cvd408
# https://dataspace.cavd.org/cds/CAVD/app.view#learn/learn/Study/cvd408?q=408
cvd408 <- con$getStudy("cvd408")

# Connect to all studies
cvd <- con$getStudy("cvd408")

# Connect to the NYVAC durability comparison group
# https://dataspace.cavd.org/cds/CAVD/app.view#group/groupsummary/220
nyvac <- con$getGroup(220)

# Refresh the connection object to update available studies and groups
con$refresh()
}

}
\seealso{
\code{\link{connectDS}} \code{\link{DataSpaceR-package}}
}
\keyword{datasets}
