% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CasesTable.R
\name{CasesTable}
\alias{CasesTable}
\title{Create reports cases after listwise deletion of missing values for 
time-series cross-sectional data.}
\usage{
CasesTable(data, GroupVar, TimeVar, Vars)
}
\arguments{
\item{data}{a data frame with the full sample.}

\item{GroupVar}{a character string specifying the variable in \code{data} 
which contains the group IDs.}

\item{TimeVar}{an optional character string specifying the variable in 
\code{data} which contains the time variable.}

\item{Vars}{a character vector with variables names from \code{data}
for which you would like to listwise delete observations with missing values.}
}
\value{
If \code{TimeVar} is specified then a data frame is returned with 
three colums. One identifying the \code{GroupVar} and two others specifying 
each unique value of \code{GroupVar}'s first and last observation time 
post-listwise deletion of missing values. 

If \code{TimeVar} is not specified, then a vector of unique \code{GroupVar}
post-listwise deletion of missing values is returned.
}
\description{
Create reports cases after listwise deletion of missing values for 
time-series cross-sectional data.
}
\examples{
# Create dummy data
ID <- rep(1:4, 4)
time <- rep(2000:2003, 4)
a <- rep(c(1:3, NA), 4)
b <- rep(c(1, NA, 3:4), 4)
Data <- data.frame(ID, time, a, b)

# Find cases that have not been listwise deleted
CasesTable(Data, GroupVar = 'ID')
CasesTable(Data, GroupVar = 'ID', Vars = 'a')
CasesTable(Data, GroupVar = 'ID', TimeVar = 'time', Vars = 'a')


}

