% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chp2.R
\name{Chapter02}
\alias{Chapter02}
\alias{print_stats}
\alias{print_freqs}
\title{Chapter 2: Descriptive Statistics}
\usage{
print_stats(x, na.rm = TRUE)

print_freqs(x, breaks, include.lowest = TRUE, right = TRUE)
}
\arguments{
\item{x}{\link[base]{numeric} vector, the observations.
In function \link{print_freqs}, this argument can also be a \link[base]{factor}}

\item{na.rm}{\link[base]{logical} scalar, whether to remove the missing observations (default \code{TRUE})}

\item{breaks}{\link[base]{numeric} vector, see \link[base]{cut.default}}

\item{include.lowest}{\link[base]{logical} scalar, default \code{TRUE}. See \link[base]{cut.default}}

\item{right}{\link[base]{logical} scalar, see \link[base]{cut.default}}
}
\value{
Function \link{print_freqs} returns a \linkS4class{freqs} object, for which
a \link[methods]{show} method, an \link[ggplot2]{autolayer} and an \link[ggplot2]{autoplot} method are defined.

Function \link{print_stats} does not have a returned value.
}
\description{
Functions and examples for Chapter 2, \emph{Descriptive Statistics}.
}
\details{
Function \link{print_freqs} prints the (relative) frequencies and cumulative (relative) frequencies, from
a numeric input vector, specified interval breaks as well as open/close status of the ends of the intervals.

Function \link{print_stats} prints the simple statistics of the input observations, such as sample size,
mean, median, (smallest) mode, variance, standard deviation,
coefficient of variation (if all observations are non-negative),
quartiles, inter-quartile range (IQR), range, skewness and kurtosis.  A histogram is also printed.
}
\examples{
library(DanielBiostatistics10th)
library(ggplot2)

# Example 2.2.1; Page 20 (10th ed), Page 19 (11th ed)
head(EXA_C01_S04_01)
class(age <- EXA_C01_S04_01$AGE) # 'integer'
sort(age) # Table 2.2.1

# Example 2.3.1; Page 23 (10th ed); Page 22 (11th ed)
(r231 = print_freqs(age, breaks = seq.int(from=30, to=90, by=10), right = FALSE)) # Table 2.3.2
# The open/close of interval ends is determined by textbook using 30-39, 40-49, etc.
autoplot(r231) + labs(title = 'Figure 2.3.2 (10th ed)')

# Example 2.4.1-2.4.6; Page 38-42 (10th ed); Page 30-34 (11th ed)
# Example 2.5.1-2.5.3; Page 44-46 (10th ed); Page 35-41 (11th ed)
print_stats(age) # or some other data input

# Example 2.5.4 (omitted); Page 49 (10th ed), Page 41 (11th ed)

# Example 2.5.5; Page 50 (10th ed)
head(EXA_C02_S05_05)
boxplot(EXA_C02_S05_05$GRF, main = c('Example 2.5.5 (10th ed)'))
print_stats(EXA_C02_S05_05$GRF)
print_freqs(EXA_C02_S05_05$GRF, breaks = seq.int(10, 45, by = 5))
}
\seealso{
\link[base]{cut.default} \link[base]{table} \link[base]{cumsum}
\link[base]{mean.default} \link[stats]{median.default} \link[pracma]{Mode}
\link[stats]{var} \link[stats]{sd} \link[stats]{quantile}
\link[e1071]{skewness} \link[e1071]{kurtosis}
}
