% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chp11.R
\name{Chapter11}
\alias{Chapter11}
\alias{predict_glm_binomial}
\title{Chapter 11}
\usage{
predict_glm_binomial(object, newx, level = 0.95, ...)
}
\arguments{
\item{object}{\link[stats]{glm} object with \link[stats]{binomial} link function, i.e., a logistic regression model,
as well as one and only one \link[base]{numeric} predictor}

\item{newx}{(optional) \link[base]{numeric} scalar or vector, new \eqn{x}-value(s) for which the fitted response(s) are to be reported}

\item{level}{\link[base]{numeric} scalar, tolerance/confidence level, default .95}

\item{...}{potential arguments, not in use currently}
}
\value{
\link{predict_glm_binomial} returns a \link{predict_glm_binomial} object, for which 
a \link[base]{print} method, an \link[ggplot2]{autolayer} and an \link[ggplot2]{autoplot} method are defined.
}
\description{
Functions for Chapter 11, \emph{Regression Analysis: Some Additional Techniques}.
}
\examples{
library(DanielBiostatistics10th)
library(car)
library(DescTools)

# Page 540, Example 11.1.1
d1111 = read.csv(system.file('extdata', 'EXA_C11_S01_01.csv', package = 'DanielBiostatistics10th'))
head(log(d1111$conc, base = 10))
head(d1111$logConc)

# Page 542, Example 11.1.2
d1112 = read.csv(system.file('extdata', 'EXA_C11_S01_02.csv', package = 'DanielBiostatistics10th'))
cor.test(~ sbp + weight, data = d1112)
cor.test(~ sbp + bmi, data = d1112) 

# Page 545, Example 11.2.1
d1121 = read.csv(system.file('extdata', 'EXA_C11_S02_01.csv', package = 'DanielBiostatistics10th'))
d1121a = within(d1121, expr = {
  SMOKE = as.logical(SMOKE)
})
xlab1121 = 'Length of gestation (weeks)'; ylab1121 = 'Birth weight (grams)'
car::scatterplot(GRAMS ~ WEEKS | SMOKE, data = d1121a, regLine = FALSE, smooth = FALSE,
                 xlab = xlab1121, ylab = ylab1121, main = 'Page 547, Figure 11.2.1')
# Page 547, Figure 11.2.2: main model (without interaction)
summary(m1121_main <- lm(GRAMS ~ WEEKS + SMOKE, data = d1121a))
confint(m1121_main)
car::scatterplot(GRAMS ~ WEEKS | SMOKE, data = d1121a, regLine = FALSE, smooth = FALSE,
                 xlab = xlab1121, ylab = ylab1121, main = 'Page 548, Figure 11.2.3')
(cf_main = m1121_main$coefficients)
abline(a = cf_main[1L], b = cf_main[2L], col = 'blue') # regression line for non-smoking mothers
abline(a = cf_main[1L] + cf_main[3L], b = cf_main[2L], col = 'magenta') 

# Page 551, Example 11.2.3
d1123 = read.csv(system.file('extdata', 'EXA_C11_S02_03.csv', package = 'DanielBiostatistics10th'))
d1123a = within(d1123, expr = {
  METHOD = factor(METHOD, levels = c('C', 'A', 'B')) # textbook designated 'C' as reference level
})
summary(mod_1123 <- lm(EFFECT ~ AGE * METHOD, data = d1123a)) # Page 555, Figure 11.2.5
confint(mod_1123)
car::scatterplot(EFFECT ~ AGE | METHOD, data = d1123a, smooth = FALSE,
                 xlab = 'Age', ylab = 'Treatment effectiveness', main = 'Page 555, Figure 11.2.6')

# (optional) Page 561, Example 11.3.1
d1131 = read.csv(system.file('extdata', 'EXA_C11_S03_01.csv', package = 'DanielBiostatistics10th'))
head(d1131)
names(d1131) = c('JOBPER', 'ASRV', 'ENTH', 'AMB', 'COMM', 'PROB', 'INIT')
summary(mod_1131_raw <- lm(JOBPER ~ ASRV + ENTH + AMB + COMM + PROB + INIT, data = d1131))
# summary(mod_1131 <- MASS::stepAIC(mod_1131_raw, direction = 'backward'))
# the stepwise selection criterion used in MINITAB is not necessarily AIC

# Page 572, Example 11.4.1
addmargins(d1141 <- array(c(92L, 21L, 15L, 20L), dim = c(2L, 2L), dimnames = list(
  OCAD = c('Present', 'Absent'), Sex = c('Male', 'Female')))) # Page 572, Table 11.4.2
(d1141a = within(as.data.frame(as.table(d1141)), expr = {
  OCAD = (OCAD == 'Present')
  Sex = factor(Sex, levels = c('Female', 'Male'))
}))
(m1141 = glm(OCAD ~ Sex, family = binomial(link = 'logit'), weights = Freq, data = d1141a))
summary(m1141) # Page 573, Figure 11.4.1
exp(m1141$coefficients[2L]) # exp(beta_M)
exp(confint(m1141)) # confidence interval of exp(beta)
predict(m1141, newdata = data.frame(Sex = setNames(nm = c('Male', 'Female'))), type = 'response')

# Page 573, Example 11.4.2
d1142 = read.csv(system.file('extdata', 'EXA_C11_S04_02.csv', package = 'DanielBiostatistics10th'))
summary(mod_1142 <- glm(ATT ~ AGE, family = binomial, data = d1142)) # Page 575, Figure 11.4.2
exp(mod_1142$coefficients[2L])
exp(confint(mod_1142))
car::Anova(mod_1142) # Optional
autoplot(predict_glm_binomial(mod_1142, newx = c(50, 65, 80)), title = 'Page 576, Figure 11.4.3')

# (optional) Page 576, Example 11.4.3
d1143 = read.csv(system.file('extdata', 'REV_C11_24.csv', package = 'DanielBiostatistics10th'))
summary(glm(ONSET ~ HIAA + TRYPT, family = binomial(link = 'logit'), data = d1143)) 
# Page 577, Figure 11.4.4
# Predictor TRYPT should be removed from model due to p-value \approx 1 
summary(glm(ONSET ~ HIAA, family = binomial(link = 'logit'), data = d1143)) 

# (optional) Page 578, Example 11.4.4
DescTools::PseudoR2(mod_1142, which = 'CoxSnell')
DescTools::PseudoR2(mod_1142, which = 'Nagelkerke')

# (optional) Page 579, Example 11.4.5 (same as Example 11.4.4)
}
\references{
Wayne W. Daniel, \emph{Biostatistics: A Foundation for Analysis in the Health Sciences}, Tenth Edition.
Wiley, ISBN: 978-1-119-62550-6.
}
\seealso{
\link[stats]{predict.glm}
}
