% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEM.R
\name{DEM}
\alias{DEM}
\title{Distributed EM Imputation (DEM) for Handling Missing Data}
\usage{
DEM(data0, data.sample, data.copy, mr, km, D)
}
\arguments{
\item{data0}{The original dataset containing the response variable and features.}

\item{data.sample}{The dataset used for sampling, which may contain missing values.}

\item{data.copy}{A copy of the original dataset, used for comparison or validation.}

\item{mr}{Indices of the rows with missing values that need to be predicted.}

\item{km}{The number of clusters for k-means clustering.}

\item{D}{The number of blocks to divide the data into.}
}
\value{
A list containing:
\item{XDEM}{The imputed dataset.}
\item{RMSEDEM}{The Root Mean Squared Error.}
\item{MAEDEM}{The Mean Absolute Error.}
\item{REDEM}{The Relative Eelative Error.}
\item{GCVDEM}{The DEM Imputation for Generalized Cross-Validation.}
\item{timeDEM}{The DEM algorithm execution time.}
}
\description{
This function performs DEM to handle missing data by dividing the dataset into D blocks,
applying the EM imputation method within each block, and then combining the results.
It calculates various evaluation metrics including RMSE, MMAE, RRE, and Consistency
Proportion Index (CPP) using different hierarchical clustering methods.
}
\examples{
# Create a sample dataset with missing values
set.seed(123)
n <- 100
p <- 5
data.sample <- matrix(rnorm(n * p), nrow = n)
data.sample[sample(1:(n*p), 20)] <- NA
data.copy <- data.sample
data0 <- data.frame(data.sample, response = rnorm(n))
mr <- sample(1:n, 10)  # Sample rows for evaluation
km <- 3  # Number of clusters
D <- 2  # Number of blocks
# Perform DEM imputation
result <- DEM(data0, data.sample, data.copy, mr, km, D)
# Print the results
print(result$XDEM)

}
\seealso{
\code{\link{EM}} for the original EM function.
}
\keyword{DEM}
\keyword{EM}
\keyword{clustering}
\keyword{imputation}
\keyword{k-means}
