% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{class}
\name{Region-class}
\alias{Region-class}
\alias{plot,Region,ANY-method}
\alias{plot,Region-method}
\title{S4 Class "Region"}
\usage{
\S4method{plot}{Region,ANY}(x, y, type = "l", add = FALSE,
  plot.units = character(0), ...)
}
\arguments{
\item{x}{the coordinates of points in the plot. Alternatively, a
      single plotting structure, function or \emph{any \R object with a
        \code{plot} method} can be provided.}

\item{y}{the y coordinates of points in the plot, \emph{optional}
    if \code{x} is an appropriate structure.}
    
\item{type}{supplies the type for the Population plot method}

\item{add}{when implemented allows multiple object to be added
    over the top of the existing plot}
  
\item{plot.units}{allows the plot to have different units than 
    the region or density object ('m' or 'km')}

\item{...}{Arguments to be passed to methods, such as
    \link{graphical parameters} (see \code{\link{par}}).
    Many methods will accept the following arguments:
    \describe{
    \item{\code{type}}{what type of plot should be drawn.  Possible types are
      \itemize{
        \item \code{"p"} for \bold{p}oints,
        \item \code{"l"} for \bold{l}ines,
        \item \code{"b"} for \bold{b}oth,
        \item \code{"c"} for the lines part alone of \code{"b"},
        \item \code{"o"} for both \sQuote{\bold{o}verplotted},
        \item \code{"h"} for \sQuote{\bold{h}istogram} like (or
        \sQuote{high-density}) vertical lines,
        \item \code{"s"} for stair \bold{s}teps,
        \item \code{"S"} for other \bold{s}teps, see \sQuote{Details} below,
        \item \code{"n"} for no plotting.
      }
      All other \code{type}s give a warning or an error; using, e.g.,
      \code{type = "punkte"} being equivalent to \code{type = "p"} for S
      compatibility.  Note that some methods,
      e.g. \code{\link{plot.factor}}, do not accept this.
    }
    \item{\code{main}}{an overall title for the plot: see \code{\link{title}}.}
    \item{\code{sub}}{a sub title for the plot: see \code{\link{title}}.}
    \item{\code{xlab}}{a title for the x axis: see \code{\link{title}}.}
    \item{\code{ylab}}{a title for the y axis: see \code{\link{title}}.}
    \item{\code{asp}}{the \eqn{y/x} aspect ratio,
      see \code{\link{plot.window}}.}
    }
  }
}
\description{
S4 Class "Region"
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{make.region(region.name = "region.name",}
\code{  shapefile = region.shapefile)}
}

\section{Slots}{

\describe{
 \item{\code{region.name}}{Object of class \code{"character"}; giving the
 name of the region.}
 \item{\code{strata.name}}{Object of class \code{"character"}; character
 vector giving the names of the strata.}
 \item{\code{strata.name}}{Object of class \code{"character"}; character
 vector giving the names of the strata.}
 \item{\code{units}}{Object of class \code{"character"}; character describing
 the coordinate units ("km" or "m")}
 \item{\code{area}}{Object of class \code{"numeric"}; the area of the survey
 region}
 \item{\code{box}}{Object of class \code{"numeric"}; 4 values giving the x and
 y ranges of the region}
 \item{\code{coords}}{Object of class \code{"list"}; this list contains an
 element for each strata. Each of these list elements contains a list of polygons
 defining the region.}
 \item{\code{gaps}}{Object of class \code{"list"};this list contains an
 element for each strata. Each of these list elements contains a list of gaps
 in the region}
}
}

\section{Methods}{

\describe{
 \item{\code{get.area}}{\code{signature(obj = "Region")}: retrieves the area
 element }
 \item{\code{plot}}{\code{signature(x = "Region", y = "missing")}: plots
 the survey region defined by the object.}
}
}
\seealso{
\code{\link{make.region}}
}
\keyword{classes}

