% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{sample.nu}
\alias{sample.nu}
\title{Function to sample from the posterior of the spatial effects}
\usage{
sample.nu(Y, eta, delta, EV, V)
}
\arguments{
\item{Y}{vector of observed data.}

\item{eta}{samples of the smoothing parameter from the \code{sample.eta} function.}

\item{delta}{samples of the variance parameter from the \code{sample.delta} function.}

\item{EV}{eigenvalues of the precision matrix spatial prior from the function \code{make.M()}.}

\item{V}{eigenvectors of the precision matrix spatial prior from the function \code{make.M()}.}
}
\value{
A matrix of samples with each column a random draw from the posterior
of the spatial effects from the DSSP model \eqn{\pi(nu | eta, delta, y)}.
}
\description{
This function samples from the posterior density of the spatial effects from the direct sampling
 spatial prior (DSSP) model.
}
\examples{
## Use the Meuse River dataset from the package 'gstat'

library(sp)
library(gstat)
data(meuse.all)
coordinates(meuse.all) <- ~ x + y
X <- scale(coordinates(meuse.all))
tmp <- make.M(X)

EV <- tmp$M.eigen$values
V <- tmp$M.eigen$vectors

Y <- scale(log(meuse.all$zinc))
Q <- crossprod(Y, V)

ND <- nrow(X) - 3
f <- function(x) -x ## log-prior for exponential distribution for the smoothing parameter
## Draw 100 samples from the posterior of eta given the data y.

ETA <- sample.eta(100, ND, EV, Q, f, UL = 1000)
DELTA <- sample.delta(ETA, ND, EV, Q, pars = c(0.001, 0.001))
NU <- sample.nu(Y, ETA, DELTA, EV, V)
}
