% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_basicvirus_ode.R
\name{simulate_basicvirus_ode}
\alias{simulate_basicvirus_ode}
\title{Basic Virus model - ODE}
\usage{
simulate_basicvirus_ode(
  U = 1e+05,
  I = 0,
  V = 10,
  n = 0,
  dU = 0,
  dI = 1,
  dV = 4,
  b = 1e-06,
  p = 100,
  g = 1,
  tstart = 0,
  tfinal = 50,
  dt = 0.1
)
}
\arguments{
\item{U}{: Starting value for uninfected cells : numeric}

\item{I}{: Starting value for infected cells : numeric}

\item{V}{: Starting value for virus : numeric}

\item{n}{: Rate of new uninfected cell replenishment : numeric}

\item{dU}{: Rate at which uninfected cells die : numeric}

\item{dI}{: Rate at which infected cells die : numeric}

\item{dV}{: Rate at which virus is cleared : numeric}

\item{b}{: Rate at which virus infects cells : numeric}

\item{p}{: Rate at which infected cells produce virus : numeric}

\item{g}{: Possible conversion factor for virus units : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Times for which result is returned : numeric}
}
\value{
The function returns the output as a list.
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}.
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
A basic virus infection model with 3 compartments, implemented as ODEs. The model tracks uninfected and infected target cells and free virus. The processes modeled are infection, virus production, uninfected cell birth and death, infected cell and virus death.
}
\details{
The model is implemented as a set of ordinary differential equations (ODE) using the deSolve package.
This code is part of the DSAIRM R package.
For additional model details, see the corresponding app in the DSAIRM package.
}
\section{Notes}{
 The parameter dt only determines for which times the solution is returned, it is not the internal time step. The latter is set automatically by the ODE solver.
}

\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters:
result <- simulate_basicvirus_ode()
}
