% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{dmcFitDE}
\alias{dmcFitDE}
\title{dmcFitDE: Fit DMC to aggregated data using R-package DEoptim (Differential Evolution)}
\usage{
dmcFitDE(
  resOb,
  nTrl = 1e+05,
  minVals = list(),
  maxVals = list(),
  fixedFit = list(),
  nCAF = 5,
  nDelta = 19,
  pDelta = vector(),
  tDelta = 1,
  costFunction = "RMSE",
  spDist = 1,
  drDist = 0,
  drShape = 3,
  drLim = c(0.1, 0.7),
  rtMax = 5000,
  deControl = list()
)
}
\arguments{
\item{resOb}{Observed data (see flankerData and simonTask for data format)}

\item{nTrl}{The number of trials to use within dmcSim.}

\item{minVals}{Minimum values for the to-be estimated parameters. This is a list with values specified individually
for amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, sigm (e.g., minVals = list(amp = 10, tau = 5, drc = 0.1,
bnds = 20, resMean = 200, resSD = 5, aaShape = 1, spShape = 2, spBias = -20, sigm = 1)).}

\item{maxVals}{Maximum values for the to-be estimated parameters. This is a list with values specified individually
for amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, sigm (e.g., maxVals = list(amp = 40, tau = 300, drc = 1.0,
bnds = 150, resMean = 800, resSD = 100, aaShape = 3, spShape = 4, spBias = 20, sigm = 10))}

\item{fixedFit}{Fix parameter to starting value. This is a list with bool values specified individually for
amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, sigm (e.g., fixedFit = list(amp = F,  tau = F, drc = F,
bnds = F, resMean = F, resSD = F, aaShape = F, spShape = F, spBias = T, sigm = T))}

\item{nCAF}{The number of CAF bins.}

\item{nDelta}{The number of delta bins.}

\item{pDelta}{An alternative option to nDelta by directly specifying required percentile values (vector of values 0-100)}

\item{tDelta}{The type of delta calculation (1=direct percentiles points, 2=percentile bounds (tile) averaging)}

\item{costFunction}{The cost function to minimise: root mean square error ("RMSE": default),
squared percentage error ("SPE"), or likelihood-ratio chi-square statistic ("GS")}

\item{spDist}{The starting point distribution (0 = constant, 1 = beta, 2 = uniform)}

\item{drDist}{The drift rate (dr) distribution type (0 = constant, 1 = beta, 2 = uniform)}

\item{drShape}{The drift rate (dr) shape parameter}

\item{drLim}{The drift rate (dr) range}

\item{rtMax}{The limit on simulated RT (decision + non-decisional components)}

\item{deControl}{Additional control parameters passed to DEoptim (see DEoptim.control)}
}
\value{
dmcfit

\item{obj$means}{Condition means for reaction time and error rate}
\item{obj$caf}{Accuracy per bin for compatible and incompatible trials}
\item{obj$delta}{Mean RT and compatibility effect per bin}
\item{obj$sim}{Individual trial data points (RTs for all trial types e.g., correct/error trials) and activation}
\item{obj$par}{The fitted model parameters + final cost value of the fit}
}
\description{
Fit theoretical data generated from dmcSim to observed data by
minimizing the root-mean-square error (RMSE) between a weighted combination
of the CAF and CDF functions using the R-package DEoptim. Alternative cost functions
include squared percentage error ("SPE"), and g-squared statistic ("GS").
}
\examples{
\donttest{
# Example 1: Flanker data from Ulrich et al. (2015)
fit <- dmcFitDE(flankerData)
plot(fit, flankerData)
summary(fit)

# Example 2: Simon data from Ulrich et al. (2015)
fit <- dmcFitDE(simonData, nTrl = 20000)
plot(fit, simonData)
summary(fit)
}
}
