% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{popdynCPP}
\alias{popdynCPP}
\title{Population dynamics model in CPP}
\usage{
popdynCPP(nareas, maxage, Ncurr, pyears, M_age, MatAge, WtAge, Vuln, Retc, Prec,
  movc, SRrelc, Effind, Spat_targc, hc, R0c, SSBpRc, aRc, bRc, Qc, Fapic, maxF,
  control)
}
\arguments{
\item{nareas}{The number of spatial areas}

\item{maxage}{The maximum age}

\item{Ncurr}{A numeric matrix (maxage, nareas) with current numbers-at-age in each area}

\item{pyears}{The number of years to project the population forward}

\item{M_age}{Numeric matrix (maxage, pyears) with natural mortality by age and year}

\item{MatAge}{Numeric vector with proportion mature by age}

\item{WtAge}{Numeric matrix (maxage, pyears) with weight by age and year}

\item{Vuln}{Numeric matrix (maxage, pyears) with vulnerability by age and year}

\item{Retc}{Numeric matrix (maxage, pyears) with retention by age and year}

\item{Prec}{Numeric vector (pyears) with recruitment error}

\item{SRrelc}{Integer indicating the stock-recruitment relationship to use (1 for Beverton-Holt, 2 for Ricker)}

\item{Effind}{Numeric vector (length pyears) with the fishing effort by year}

\item{Spat_targc}{Integer. Spatial targetting}

\item{hc}{Numeric. Steepness of stock-recruit relationship}

\item{R0c}{Numeric vector of length nareas with unfished recruitment by area}

\item{SSBpRc}{Numeric vector of length nareas with unfished spawning per recruit by area}

\item{aRc}{Numeric. Ricker SRR a value by area}

\item{bRc}{Numeric. Ricker SRR b value by area}

\item{Qc}{Numeric. Catchability coefficient}

\item{Fapic}{Numeric. Apical F value}

\item{maxF}{A numeric value specifying the maximum fishing mortality for any single age class}

\item{control}{Integer. 1 to use q and effort to calculate F, 2 to use Fapic (apical F) and 
vulnerablity to calculate F.}

\item{SSBcurr}{A numeric vector of length nareas with the current spawning biomass in each area}

\item{mov}{Numeric matrix (nareas by nareas) with the movement matrix}
}
\description{
Project population forward pyears given current numbers-at-age and total mortality, etc 
for the future years
}
\author{
A. Hordyk
}
\keyword{internal}
