% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admort.R
\name{admort}
\alias{admort}
\title{Calculates adult and maternal mortality indicators based on survey data.}
\usage{
admort(
  Data.Name,
  Indicator,
  JK = NULL,
  CL = NULL,
  Strata = NULL,
  Cluster = NULL,
  Weight = NULL,
  Date_of_interview = NULL,
  PeriodEnd = NULL,
  Period = NULL
)
}
\arguments{
\item{Data.Name}{The DHS women (IR) dataset or data from other survey with the same format.}

\item{Indicator}{Type of indicator to be calculated ("asmr", "aamr", "asmmr", "aammr", "asprmr", "aaprmr", "mmr", "prmr", "aagfr").}

\item{JK}{"Yes" to estimate Jackknife SE for AAMR, AAMMR, AAPRMR, MMR and PRMR.}

\item{CL}{Confidence level to calculate the Confidence Coefficient Z of the Confidence Intervals; default if 95.}

\item{Strata}{Stratification variable if other than "v022".}

\item{Cluster}{Sample cluster variable if other than "v021".}

\item{Weight}{Survey weight variable if other than "v005".}

\item{Date_of_interview}{Date of Interview (CMC) variable if other than "v008".}

\item{PeriodEnd}{The end of the exposure period in YYYY-MM format; default is the date of the survey.}

\item{Period}{The study period for fertility in months; default is 36 months (3 years).}
}
\value{
Mortality indicators (ASMR, AAMR, ASMMR, AAMMR, ASPRMR, AAPRMR, MMR, PRMR and AAGFR), and precision indicators (SE, DEFT, RSE, and CI).
}
\description{
\code{admort} returns adult mortality indicators such as the Age Specific Mortality Rate (ASMR),
Age Adjusted Mortality Rate (AAMR), Age Specific Maternal Mortality Rate (ASMMR),
Age Adjusted Maternal Mortality Rate (AAMMR), Age Specific Pregnancy Related Mortality Rate (ASPRMR),
Age Adjusted Pregnancy Related Mortality Rate (AAPRMR), Maternal Mortality Ratio (MMR) and Pregnancy Related Mortality Ratio (PRMR).
\code{admort} returns the Standard Error (SE), exposure (N), weighted exposure (WN),
Design Effect (DEFT), Relative Standard Error (RSE), and Confidence Interval (CI).
}
\author{
Mahmoud Elkasabi.
}
