% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chmort.R
\name{chmort}
\alias{chmort}
\title{Calculates childhood mortality rates based on the Demographic and Health Surveys (DHS).}
\usage{
chmort(Data.Name, JK = NULL, Strata = NULL, Cluster = NULL,
  Weight = NULL, PeriodEnd = NULL, Period = NULL, Class = NULL)
}
\arguments{
\item{Data.Name}{DHS data birth files (BR).}

\item{JK}{"Yes" to estimate Jackknife SE.}

\item{Strata}{The stratification variable name if other than "v022".}

\item{Cluster}{The sampling clusters variable name if other than "v021".}

\item{Weight}{The sampling weight variable name if other than "v005".}

\item{PeriodEnd}{The end of the exposure period; default is the day of the interview.}

\item{Period}{The study period for mortality; default is 5 years.}

\item{Class}{Allow for domain level indicators.}
}
\value{
Childhood mortality rates (NNMR, PNNMR, IMR, CMR and U5MR), and precision indicators (SE, RSE and CI).
}
\description{
\code{chmort} returns childhood mortality rates such as Neonatal Mortality Rate (NNMR),
Post-neonatal Mortality Rate (PNNMR), Infant Mortality Rate (IMR), Child Mortality Rate (CMR),
and Under-5 Mortality Rate (U5MR)
\code{chmort} returns the Standrad Error (SE), Number of births contributed to the death exposure (N),
the Relative Standard Error (RSE) and the Confidence Interval (CI).
}
\examples{
# Calculate five-year children mortality rates based on ADBR70 data

data("ADBR70")
chmort(
 ADBR70,
 JK="Yes"
)

# Calculate ten-year children mortality rates based on ADBR70 data

data("ADBR70")
chmort(
 ADBR70,
 JK="Yes",
 Period = 10
)

# The exposure period ends 3 years before the survey

data("ADBR70")
chmort(
 ADBR70,
 PeriodEnd = 3
)

}
\author{
Mahmoud Elkasabi.
}
