% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_hP_methods.R
\name{predict.glm_hP}
\alias{predict.glm_hP}
\title{Predict Method for glm_hP Fits}
\usage{
\method{predict}{glm_hP}(object, newdata = NULL, type = c("link", "response"), ...)
}
\arguments{
\item{object}{a fitted object of class inheriting from \code{"glm_hP"}.}

\item{newdata}{optionally, a data frame in which to look for variables with
which to predict. If omitted, the fitted linear predictors are used.}

\item{type}{the type of prediction required. The default is on the scale of
the linear predictors; the alternative \code{"response"} is on the scale of
the response variable.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector with the prediction means.
}
\description{
Obtains predictions from a fitted \code{"glm_hP"} object.
}
\examples{
data(Bids)
Bids$size.sq <- Bids$size ^ 2
fit <- glm.hP(formula.mu = numbids ~ leglrest + rearest + finrest +
              whtknght + bidprem + insthold + size + size.sq + regulatn,
              formula.gamma = numbids ~ 1, data = Bids)
predict(fit)
}
